/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.business.policy.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.business.policy.local.entity.BusinessPolicy;
import com.biz.crm.tpm.business.business.policy.local.entity.BusinessPolicyBudget;
import com.biz.crm.tpm.business.business.policy.local.entity.BusinessPolicyProduct;
import com.biz.crm.tpm.business.business.policy.local.entity.BusinessPolicyScope;
import com.biz.crm.tpm.business.business.policy.local.repository.BusinessPolicyBudgetRepository;
import com.biz.crm.tpm.business.business.policy.local.repository.BusinessPolicyProductRepository;
import com.biz.crm.tpm.business.business.policy.local.repository.BusinessPolicyRepository;
import com.biz.crm.tpm.business.business.policy.local.repository.BusinessPolicyScopeRepository;
import com.biz.crm.tpm.business.business.policy.local.service.BusinessPolicyProductService;
import com.biz.crm.tpm.business.business.policy.sdk.dto.BusinessPolicyApprovalDto;
import com.biz.crm.tpm.business.business.policy.sdk.dto.BusinessPolicyBudgetDto;
import com.biz.crm.tpm.business.business.policy.sdk.dto.BusinessPolicyDto;
import com.biz.crm.tpm.business.business.policy.sdk.dto.BusinessPolicyProductDto;
import com.biz.crm.tpm.business.business.policy.sdk.dto.BusinessPolicyScopeDto;
import com.biz.crm.tpm.business.business.policy.sdk.dto.log.BusinessPolicyLogEventDto;
import com.biz.crm.tpm.business.business.policy.sdk.enumeration.SaveTypeEnum;
import com.biz.crm.tpm.business.business.policy.sdk.event.log.BusinessPolicyEventListener;
import com.biz.crm.tpm.business.business.policy.sdk.service.BusinessPolicyService;
import com.biz.crm.tpm.business.business.policy.sdk.vo.BusinessPolicyBudgetVo;
import com.biz.crm.tpm.business.business.policy.sdk.vo.BusinessPolicyScopeVo;
import com.biz.crm.tpm.business.business.policy.sdk.vo.BusinessPolicyVo;
import com.biz.crm.tpm.business.month.budget.sdk.dto.PromotionOperateMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.MonthBudgetTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetLockService;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.GeneralExpensesService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.GeneralExpensesVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="businessPolicyService")
public class BusinessPolicyServiceImpl
implements BusinessPolicyService {
    private static final Logger log = LoggerFactory.getLogger(BusinessPolicyServiceImpl.class);
    private static final String BUSINESS_POLICY_PREFIX = "SWZC";
    @Autowired(required=false)
    private BusinessPolicyRepository businessPolicyRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private BusinessPolicyBudgetRepository businessPolicyBudgetRepository;
    @Autowired(required=false)
    private BusinessPolicyProductRepository businessPolicyProductRepository;
    @Autowired(required=false)
    private BusinessPolicyScopeRepository businessPolicyScopeRepository;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private ProcessBusinessService processBusinessService;
    @Autowired(required=false)
    private MonthBudgetLockService monthBudgetLockService;
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;
    @Autowired(required=false)
    private GeneralExpensesService generalExpensesService;
    @Autowired(required=false)
    private BusinessPolicyProductService businessPolicyProductService;
    @Autowired(required=false)
    private RedisLockService redisLockService;

    public Page<BusinessPolicyVo> findByConditions(Pageable pageable, BusinessPolicyDto businessPolicy) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(businessPolicy)) {
            businessPolicy = new BusinessPolicyDto();
        }
        return this.businessPolicyRepository.findByConditions(pageable, businessPolicy);
    }

    public BusinessPolicyVo findById(String id) {
        List list2;
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        BusinessPolicy businessPolicyEntity = (BusinessPolicy)((Object)this.businessPolicyRepository.getById((Serializable)((Object)id)));
        BusinessPolicyVo businessPolicyVo = (BusinessPolicyVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)businessPolicyEntity, BusinessPolicyVo.class, null, null, new String[0]);
        List list = ((LambdaQueryChainWrapper)this.businessPolicyBudgetRepository.lambdaQuery().eq(BusinessPolicyBudget::getBusinessPolicyCode, (Object)businessPolicyEntity.getBusinessPolicyCode())).list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            Collection businessPolicyBudgetVos = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)list, BusinessPolicyBudget.class, BusinessPolicyBudgetVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            businessPolicyVo.setBusinessPolicyBudgetVoList((List)businessPolicyBudgetVos);
        }
        if (!CollectionUtils.isEmpty((Collection)(list2 = ((LambdaQueryChainWrapper)this.businessPolicyScopeRepository.lambdaQuery().eq(BusinessPolicyScope::getBusinessPolicyCode, (Object)businessPolicyEntity.getBusinessPolicyCode())).list()))) {
            Collection businessPolicyScopeVos = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)list2, BusinessPolicyScope.class, BusinessPolicyScopeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            businessPolicyVo.setBusinessPolicyScopeVoList((List)businessPolicyScopeVos);
        }
        return businessPolicyVo;
    }

    @Transactional(rollbackFor={Exception.class})
    public void create(BusinessPolicyDto businessPolicy) {
        List businessPolicyScopeDtoList;
        this.createValidate(businessPolicy);
        businessPolicy.setTenantCode(TenantUtils.getTenantCode());
        String code = (String)this.generateCodeService.generateCode(BUSINESS_POLICY_PREFIX, 1, Integer.valueOf(5), 2L, TimeUnit.DAYS).get(0);
        businessPolicy.setBusinessPolicyCode(code);
        businessPolicy.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
        businessPolicy.setId(null);
        BusinessPolicy businessPolicyEntity = (BusinessPolicy)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)businessPolicy, BusinessPolicy.class, null, null, new String[0]));
        this.businessPolicyRepository.saveOrUpdate((Object)businessPolicyEntity);
        businessPolicy.setId(businessPolicyEntity.getId());
        List businessPolicyBudgetDtoList = businessPolicy.getBusinessPolicyBudgetDtoList();
        if (!CollectionUtils.isEmpty((Collection)businessPolicyBudgetDtoList)) {
            businessPolicyBudgetDtoList.forEach(item -> {
                item.setBusinessPolicyCode(code);
                item.setTenantCode(TenantUtils.getTenantCode());
                item.setId(null);
                item.setFeeRatio(item.getApplyAmount().divide(item.getEstimateSaleAmount(), 6, 4).multiply(new BigDecimal(100)));
            });
            Collection businessPolicyBudgets = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)businessPolicyBudgetDtoList, BusinessPolicyBudgetDto.class, BusinessPolicyBudget.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            this.businessPolicyBudgetRepository.saveBatch(businessPolicyBudgets);
        }
        List businessPolicyProductDtoList = this.businessPolicyProductService.findCacheList(businessPolicy.getCacheKey());
        if (!CollectionUtils.isEmpty((Collection)businessPolicyBudgetDtoList)) {
            businessPolicyProductDtoList.forEach(item -> {
                item.setBusinessPolicyCode(code);
                item.setTenantCode(TenantUtils.getTenantCode());
                item.setId(null);
            });
            Collection businessPolicyProducts = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)businessPolicyProductDtoList, BusinessPolicyProductDto.class, BusinessPolicyProduct.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            this.businessPolicyProductRepository.saveBatch(businessPolicyProducts);
        }
        if (!CollectionUtils.isEmpty((Collection)(businessPolicyScopeDtoList = businessPolicy.getBusinessPolicyScopeDtoList()))) {
            businessPolicyScopeDtoList.forEach(item -> {
                item.setBusinessPolicyCode(code);
                item.setTenantCode(TenantUtils.getTenantCode());
                item.setId(null);
            });
            Collection businessPolicyScopes = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)businessPolicyScopeDtoList, BusinessPolicyScopeDto.class, BusinessPolicyScope.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            this.businessPolicyScopeRepository.saveBatch(businessPolicyScopes);
        }
        if (SaveTypeEnum.SUBMIT.getCode().equals(businessPolicy.getSaveType())) {
            this.submitApproval(businessPolicy);
        }
        BusinessPolicyLogEventDto logEventDto = new BusinessPolicyLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(businessPolicy);
        SerializableBiConsumer & Serializable onCreate = BusinessPolicyEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, BusinessPolicyEventListener.class, (SerializableBiConsumer)onCreate);
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(BusinessPolicyDto businessPolicy) {
        this.updateValidate(businessPolicy);
        BusinessPolicyVo oldVo = this.findById(businessPolicy.getId());
        Validate.isTrue((!ProcessStatusEnum.PASS.getDictCode().equals(oldVo.getProcessStatus()) && !ProcessStatusEnum.COMMIT.getDictCode().equals(oldVo.getProcessStatus()) ? 1 : 0) != 0, (String)"\u5ba1\u6279\u4e2d\u6216\u5ba1\u6279\u901a\u8fc7\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u4fee\u6539", (Object[])new Object[0]);
        businessPolicy.setTenantCode(TenantUtils.getTenantCode());
        BusinessPolicy businessPolicyEntity = (BusinessPolicy)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)businessPolicy, BusinessPolicy.class, null, null, new String[0]));
        this.businessPolicyRepository.updateById((Object)businessPolicyEntity);
        this.businessPolicyBudgetRepository.remove((Wrapper)Wrappers.lambdaUpdate(BusinessPolicyBudget.class).eq(BusinessPolicyBudget::getBusinessPolicyCode, (Object)businessPolicyEntity.getBusinessPolicyCode()));
        List businessPolicyBudgetDtoList = businessPolicy.getBusinessPolicyBudgetDtoList();
        if (!CollectionUtils.isEmpty((Collection)businessPolicyBudgetDtoList)) {
            businessPolicyBudgetDtoList.forEach(item -> {
                item.setId(null);
                item.setBusinessPolicyCode(businessPolicyEntity.getBusinessPolicyCode());
                item.setTenantCode(TenantUtils.getTenantCode());
                item.setFeeRatio(item.getApplyAmount().divide(item.getEstimateSaleAmount(), 6, 4).multiply(new BigDecimal(100)));
            });
            Collection businessPolicyBudgets = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)businessPolicyBudgetDtoList, BusinessPolicyBudgetDto.class, BusinessPolicyBudget.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            this.businessPolicyBudgetRepository.saveBatch(businessPolicyBudgets);
        }
        this.businessPolicyProductRepository.remove((Wrapper)Wrappers.lambdaUpdate(BusinessPolicyProduct.class).eq(BusinessPolicyProduct::getBusinessPolicyCode, (Object)businessPolicyEntity.getBusinessPolicyCode()));
        List businessPolicyProductDtoList = this.businessPolicyProductService.findCacheList(businessPolicy.getCacheKey());
        if (!CollectionUtils.isEmpty((Collection)businessPolicyProductDtoList)) {
            businessPolicyProductDtoList.forEach(item -> {
                item.setId(null);
                item.setBusinessPolicyCode(businessPolicyEntity.getBusinessPolicyCode());
                item.setTenantCode(TenantUtils.getTenantCode());
            });
            Collection businessPolicyProducts = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)businessPolicyProductDtoList, BusinessPolicyProductDto.class, BusinessPolicyProduct.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            this.businessPolicyProductRepository.saveBatch(businessPolicyProducts);
        }
        this.businessPolicyScopeRepository.remove((Wrapper)Wrappers.lambdaUpdate(BusinessPolicyScope.class).eq(BusinessPolicyScope::getBusinessPolicyCode, (Object)businessPolicyEntity.getBusinessPolicyCode()));
        List businessPolicyScopeDtoList = businessPolicy.getBusinessPolicyScopeDtoList();
        if (!CollectionUtils.isEmpty((Collection)businessPolicyScopeDtoList)) {
            businessPolicyScopeDtoList.forEach(item -> {
                item.setId(null);
                item.setBusinessPolicyCode(businessPolicyEntity.getBusinessPolicyCode());
                item.setTenantCode(TenantUtils.getTenantCode());
            });
            Collection businessPolicyScopes = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)businessPolicyScopeDtoList, BusinessPolicyScopeDto.class, BusinessPolicyScope.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            this.businessPolicyScopeRepository.saveBatch(businessPolicyScopes);
        }
        if (SaveTypeEnum.SUBMIT.getCode().equals(businessPolicy.getSaveType())) {
            this.submitApproval(businessPolicy);
        }
        BusinessPolicyLogEventDto logEventDto = new BusinessPolicyLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(businessPolicy);
        SerializableBiConsumer & Serializable onUpdate = BusinessPolicyEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, BusinessPolicyEventListener.class, (SerializableBiConsumer)onUpdate);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List businessPolicyList1 = this.businessPolicyRepository.listByIds(idList);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)businessPolicyList1) ? 1 : 0) != 0, (String)"\u8981\u5220\u9664\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (BusinessPolicy businessPolicy : businessPolicyList1) {
            Validate.isTrue((!ProcessStatusEnum.PASS.getDictCode().equals(businessPolicy.getProcessStatus()) && !ProcessStatusEnum.COMMIT.getDictCode().equals(businessPolicy.getProcessStatus()) ? 1 : 0) != 0, (String)"\u5ba1\u6279\u4e2d\u6216\u5ba1\u6279\u901a\u8fc7\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u5220\u9664", (Object[])new Object[0]);
        }
        ArrayList businessPolicyList = new ArrayList();
        businessPolicyList1.forEach(item -> {
            BusinessPolicy businessPolicy = new BusinessPolicy();
            businessPolicy.setId(item.getId());
            businessPolicy.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            businessPolicyList.add(businessPolicy);
            BusinessPolicyLogEventDto logEventDto = new BusinessPolicyLogEventDto();
            BusinessPolicyVo oldVo = (BusinessPolicyVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, BusinessPolicyVo.class, null, null, new String[0]);
            logEventDto.setOriginal(oldVo);
            BusinessPolicyDto businessPolicyDto = (BusinessPolicyDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, BusinessPolicyDto.class, null, null, new String[0]);
            businessPolicyDto.setDelFlag(businessPolicy.getDelFlag());
            logEventDto.setNewest(businessPolicyDto);
            SerializableBiConsumer & Serializable onDelete = BusinessPolicyEventListener::onDelete;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, BusinessPolicyEventListener.class, (SerializableBiConsumer)onDelete);
        });
        this.businessPolicyRepository.updateBatchById(businessPolicyList);
    }

    public void close(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List businessPolicyList1 = this.businessPolicyRepository.listByIds(idList);
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List collect = businessPolicyList1.stream().filter(x -> !x.getProcessStatus().equals(ProcessStatusEnum.PASS.getDictCode())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect)) {
            throw new IllegalArgumentException("\u6570\u636e\u96c6\u4e2d\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
        }
        List codeList = businessPolicyList1.stream().map(e -> e.getBusinessPolicyCode()).collect(Collectors.toList());
        List generalExpensesVoList = this.generalExpensesService.findByBusinessPolicyCode(codeList);
        if (!CollectionUtils.isEmpty((Collection)generalExpensesVoList)) {
            throw new IllegalArgumentException("\u5546\u52a1\u653f\u7b56\u3010" + ((GeneralExpensesVo)generalExpensesVoList.get(0)).getCommercePolicyCode() + "\u3011\u5728\u4fc3\u9500\u89c4\u5212\u3010" + ((GeneralExpensesVo)generalExpensesVoList.get(0)).getPromotionPlanCode() + "\u3011\u4e2d\u88ab\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u5173\u95ed");
        }
        ArrayList businessPolicyList = new ArrayList();
        businessPolicyList1.forEach(item -> {
            BusinessPolicy businessPolicy = new BusinessPolicy();
            businessPolicy.setId(item.getId());
            businessPolicy.setProcessStatus(ProcessStatusEnum.COLSE.getDictCode());
            businessPolicyList.add(businessPolicy);
            BusinessPolicyLogEventDto logEventDto = new BusinessPolicyLogEventDto();
            BusinessPolicyVo oldVo = (BusinessPolicyVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, BusinessPolicyVo.class, null, null, new String[0]);
            logEventDto.setOriginal(oldVo);
            BusinessPolicyDto businessPolicyDto = (BusinessPolicyDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, BusinessPolicyDto.class, null, null, new String[0]);
            businessPolicyDto.setProcessStatus(businessPolicy.getProcessStatus());
            logEventDto.setNewest(businessPolicyDto);
            SerializableBiConsumer & Serializable onClose = BusinessPolicyEventListener::onClose;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, BusinessPolicyEventListener.class, (SerializableBiConsumer)onClose);
        });
        this.businessPolicyRepository.updateBatchById(businessPolicyList);
    }

    public void batchSubmitApproval(BusinessPolicyApprovalDto dto) {
        List ids = dto.getIds();
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)ids) ? 1 : 0) != 0, (String)"\u63d0\u4ea4\u5ba1\u6279\u6d41\u7684id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (String id : ids) {
            BusinessPolicy businessPolicy = (BusinessPolicy)((Object)this.businessPolicyRepository.getById((Serializable)((Object)id)));
            Validate.notNull((Object)((Object)businessPolicy), (String)"\u672a\u627e\u5230id\u4e3a\u3010%s\u3011\u7684\u6838\u9500\u6570\u636e", (Object[])new Object[0]);
            Validate.isTrue((ProcessStatusEnum.PREPARE.getDictCode().equals(businessPolicy.getProcessStatus()) || ProcessStatusEnum.REJECT.getDictCode().equals(businessPolicy.getProcessStatus()) || ProcessStatusEnum.RECOVER.getDictCode().equals(businessPolicy.getProcessStatus()) ? 1 : 0) != 0, (String)"\u53ea\u80fd\u63d0\u4ea4\u5904\u4e8e\u9a73\u56de\uff0c\u8ffd\u56de\uff0c\u5f85\u63d0\u4ea4\u72b6\u6001\u7684\u6838\u9500\u7533\u8bf7", (Object[])new Object[0]);
            BusinessPolicyDto auditDto = (BusinessPolicyDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)businessPolicy, BusinessPolicyDto.class, null, null, new String[0]);
            auditDto.setProcessBusiness(dto.getProcessBusiness());
            this.submitApproval(auditDto);
        }
    }

    public List<BusinessPolicyVo> findBusinessPolicyByCode(Set<String> codes) {
        Validate.isTrue((!CollectionUtils.isEmpty(codes) ? 1 : 0) != 0, (String)"\u67e5\u8be2\u7684\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.businessPolicyRepository.lambdaQuery().in(BusinessPolicy::getBusinessPolicyCode, codes)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(BusinessPolicy::getProcessStatus, (Object)ProcessStatusEnum.PASS.getDictCode())).list();
        return CollectionUtils.isEmpty((Collection)list) ? new ArrayList<BusinessPolicyVo>() : new ArrayList(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, BusinessPolicy.class, BusinessPolicyVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateBusinessPolicyApplyAmount(List<BusinessPolicyVo> voList) {
        Validate.isTrue((!CollectionUtils.isEmpty(voList) ? 1 : 0) != 0, (String)"\u4fee\u6539\u7684\u4fc3\u9500\u653f\u7b56\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.businessPolicyRepository.updateBusinessPolicyApplyAmount(voList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnBudget(BusinessPolicyDto businessPolicyDto) {
        List list = ((LambdaQueryChainWrapper)this.businessPolicyBudgetRepository.lambdaQuery().eq(BusinessPolicyBudget::getBusinessPolicyCode, (Object)businessPolicyDto.getBusinessPolicyCode())).list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            Set budgetCodeSet = list.stream().map(BusinessPolicyBudget::getBudgetCode).collect(Collectors.toSet());
            try {
                Validate.isTrue((boolean)this.monthBudgetLockService.lock(new ArrayList(budgetCodeSet), TimeUnit.SECONDS, 1200), (String)"\u9884\u7b97\u52a0\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (Object[])new Object[0]);
                ArrayList<PromotionOperateMonthBudgetDto> dtoList = new ArrayList<PromotionOperateMonthBudgetDto>();
                for (BusinessPolicyBudget businessPolicyBudget : list) {
                    PromotionOperateMonthBudgetDto operateMonthBudgetDto = new PromotionOperateMonthBudgetDto();
                    operateMonthBudgetDto.setMonthBudgetCode(businessPolicyBudget.getBudgetCode());
                    operateMonthBudgetDto.setOperationAmount(businessPolicyBudget.getApplyAmount());
                    operateMonthBudgetDto.setBudgetType(MonthBudgetTypeEnum.MONTH_BUDGET.getCode());
                    operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                    operateMonthBudgetDto.setFeeRatio(businessPolicyBudget.getFeeRatio());
                    operateMonthBudgetDto.setBusinessCode(businessPolicyBudget.getBusinessPolicyCode());
                    dtoList.add(operateMonthBudgetDto);
                }
                this.monthBudgetService.operatePromotionBudget(dtoList);
            }
            finally {
                this.monthBudgetLockService.unLock(new ArrayList(budgetCodeSet));
            }
        }
    }

    public List<BusinessPolicyBudgetVo> findBusinessPolicyBudget(String code) {
        List list = ((LambdaQueryChainWrapper)this.businessPolicyBudgetRepository.lambdaQuery().eq(BusinessPolicyBudget::getBusinessPolicyCode, (Object)code)).list();
        return CollectionUtils.isEmpty((Collection)list) ? new ArrayList<BusinessPolicyBudgetVo>() : new ArrayList(this.nebulaToolkitService.copyCollectionByBlankList((Iterable)list, BusinessPolicyBudget.class, BusinessPolicyBudgetVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
    }

    public List<BusinessPolicyVo> findWholeAuditBusinessPolicyBudget(List<String> codes) {
        List list = ((LambdaQueryChainWrapper)this.businessPolicyRepository.lambdaQuery().in(BusinessPolicy::getBusinessPolicyCode, codes)).list();
        ArrayList<BusinessPolicyVo> businessPolicyVos = new ArrayList<BusinessPolicyVo>();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            List list1 = ((LambdaQueryChainWrapper)this.businessPolicyBudgetRepository.lambdaQuery().in(BusinessPolicyBudget::getBusinessPolicyCode, codes)).list();
            Map<String, List<BusinessPolicyBudget>> businessPolicyBudgetMap = list1.stream().collect(Collectors.groupingBy(BusinessPolicyBudget::getBusinessPolicyCode));
            for (BusinessPolicy businessPolicy : list) {
                BusinessPolicyVo businessPolicyVo = (BusinessPolicyVo)this.nebulaToolkitService.copyObjectByBlankList((Object)businessPolicy, BusinessPolicyVo.class, null, null, new String[0]);
                List<BusinessPolicyBudget> businessPolicyBudgets = businessPolicyBudgetMap.get(businessPolicyVo.getBusinessPolicyCode());
                if (!CollectionUtils.isEmpty(businessPolicyBudgets)) {
                    businessPolicyVo.setBusinessPolicyBudgetVoList((List)this.nebulaToolkitService.copyCollectionByBlankList(businessPolicyBudgets, BusinessPolicyBudget.class, BusinessPolicyBudgetVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
                }
                businessPolicyVos.add(businessPolicyVo);
            }
        }
        return businessPolicyVos;
    }

    public void updateBusinessPolicyByAuditPass(List<BusinessPolicyDto> businessPolicyDtoList) {
        this.businessPolicyRepository.updateBusinessPolicyByAuditPass(businessPolicyDtoList);
    }

    private ProcessBusinessVo submitApproval(BusinessPolicyDto dto) {
        Validate.notNull((Object)dto, (String)"\u63d0\u4ea4\u5ba1\u6279\u6d41\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        this.useBudget(dto);
        processBusiness.setBusinessNo(dto.getId());
        JSONObject jsonObject = JsonUtils.toJSONObject((Object)dto);
        processBusiness.setBusinessFormJson(jsonObject.toJSONString());
        processBusiness.setBusinessCode("ordinary_business_policy_process");
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);
        BusinessPolicy businessPolicy = new BusinessPolicy();
        businessPolicy.setId(dto.getId());
        businessPolicy.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
        businessPolicy.setProcessNo(processBusinessVo.getProcessNo());
        this.businessPolicyRepository.updateById((Object)businessPolicy);
        return processBusinessVo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void useBudget(BusinessPolicyDto dto) {
        List list = ((LambdaQueryChainWrapper)this.businessPolicyBudgetRepository.lambdaQuery().eq(BusinessPolicyBudget::getBusinessPolicyCode, (Object)dto.getBusinessPolicyCode())).list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            Set budgetCodeSet = list.stream().map(BusinessPolicyBudget::getBudgetCode).collect(Collectors.toSet());
            try {
                Validate.isTrue((boolean)this.monthBudgetLockService.lock(new ArrayList(budgetCodeSet), TimeUnit.SECONDS, 1200), (String)"\u9884\u7b97\u52a0\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (Object[])new Object[0]);
                ArrayList<PromotionOperateMonthBudgetDto> dtoList = new ArrayList<PromotionOperateMonthBudgetDto>();
                for (BusinessPolicyBudget businessPolicyBudget : list) {
                    PromotionOperateMonthBudgetDto operateMonthBudgetDto = new PromotionOperateMonthBudgetDto();
                    operateMonthBudgetDto.setMonthBudgetCode(businessPolicyBudget.getBudgetCode());
                    operateMonthBudgetDto.setOperationAmount(businessPolicyBudget.getApplyAmount());
                    operateMonthBudgetDto.setBudgetType(MonthBudgetTypeEnum.MONTH_BUDGET.getCode());
                    operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.USE.getCode());
                    operateMonthBudgetDto.setFeeRatio(businessPolicyBudget.getFeeRatio());
                    operateMonthBudgetDto.setBusinessCode(businessPolicyBudget.getBusinessPolicyCode());
                    dtoList.add(operateMonthBudgetDto);
                }
                this.monthBudgetService.operatePromotionBudget(dtoList);
            }
            finally {
                this.monthBudgetLockService.unLock(new ArrayList(budgetCodeSet));
            }
        }
    }

    private void createValidate(BusinessPolicyDto businessPolicy) {
        Validate.notNull((Object)businessPolicy, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        businessPolicy.setId(null);
        Validate.notBlank((CharSequence)businessPolicy.getCacheKey(), (String)"\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)businessPolicy.getBusinessPolicyName(), (String)"\u5546\u52a1\u653f\u7b56\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)businessPolicy.getApplyAmount(), (String)"\u7533\u8bf7\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)businessPolicy.getPolicyBeginTime(), (String)"\u653f\u7b56\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)businessPolicy.getPolicyEndTime(), (String)"\u653f\u7b56\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)businessPolicy.getBusinessPolicyBudgetDtoList()) ? 1 : 0) != 0, (String)"\u9884\u7b97\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        businessPolicy.getBusinessPolicyBudgetDtoList().forEach(item -> {
            item.setId(null);
            Validate.isTrue((boolean)Objects.nonNull(item.getApplyAmount()), (String)"\u7533\u8bf7\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)Objects.nonNull(item.getEstimateSaleAmount()), (String)"\u9884\u4f30\u9500\u552e\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((item.getEstimateSaleAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u9884\u4f30\u9500\u552e\u989d\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        });
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)businessPolicy.getBusinessPolicyScopeDtoList()) ? 1 : 0) != 0, (String)"\u653f\u7b56\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        businessPolicy.getBusinessPolicyScopeDtoList().forEach(item -> item.setId(null));
    }

    private void updateValidate(BusinessPolicyDto businessPolicy) {
        Validate.notNull((Object)businessPolicy, (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)businessPolicy.getCacheKey(), (String)"\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)businessPolicy.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)businessPolicy.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)businessPolicy.getBusinessPolicyName(), (String)"\u5546\u52a1\u653f\u7b56\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)businessPolicy.getApplyAmount(), (String)"\u7533\u8bf7\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)businessPolicy.getPolicyBeginTime(), (String)"\u653f\u7b56\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)businessPolicy.getPolicyEndTime(), (String)"\u653f\u7b56\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)businessPolicy.getBusinessPolicyBudgetDtoList()) ? 1 : 0) != 0, (String)"\u9884\u7b97\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        businessPolicy.getBusinessPolicyBudgetDtoList().forEach(item -> {
            item.setId(null);
            Validate.isTrue((boolean)Objects.nonNull(item.getApplyAmount()), (String)"\u7533\u8bf7\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)Objects.nonNull(item.getEstimateSaleAmount()), (String)"\u9884\u4f30\u9500\u552e\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((item.getEstimateSaleAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u9884\u4f30\u9500\u552e\u989d\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        });
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)businessPolicy.getBusinessPolicyScopeDtoList()) ? 1 : 0) != 0, (String)"\u653f\u7b56\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        businessPolicy.getBusinessPolicyScopeDtoList().forEach(item -> item.setId(null));
        BusinessPolicy one = (BusinessPolicy)((Object)this.businessPolicyRepository.getById((Serializable)((Object)businessPolicy.getId())));
        Validate.isTrue((ProcessStatusEnum.PREPARE.getDictCode().equals(one.getProcessStatus()) || ProcessStatusEnum.REJECT.getDictCode().equals(one.getProcessStatus()) || ProcessStatusEnum.RECOVER.getDictCode().equals(one.getProcessStatus()) ? 1 : 0) != 0, (String)"\u53ea\u80fd\u63d0\u4ea4\u5904\u4e8e\u9a73\u56de\uff0c\u8ffd\u56de\uff0c\u5f85\u63d0\u4ea4\u72b6\u6001\u7684\u6838\u9500\u7533\u8bf7", (Object[])new Object[0]);
    }
}

