/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.business.policy.local.workFlowListener;

import com.biz.crm.tpm.business.business.policy.local.entity.BusinessPolicy;
import com.biz.crm.tpm.business.business.policy.local.repository.BusinessPolicyRepository;
import com.biz.crm.tpm.business.business.policy.sdk.dto.BusinessPolicyDto;
import com.biz.crm.tpm.business.business.policy.sdk.service.BusinessPolicyService;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.io.Serializable;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrdinaryBusinessPolicyProcessCallBackListener
implements ProcessCompleteListener {
    private static final Logger log = LoggerFactory.getLogger(OrdinaryBusinessPolicyProcessCallBackListener.class);
    @Autowired(required=false)
    private BusinessPolicyRepository businessPolicyRepository;
    @Autowired(required=false)
    private BusinessPolicyService businessPolicyService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public String getBusinessCode() {
        return "ordinary_business_policy_process";
    }

    public void onProcessComplete(ProcessStatusDto dto) {
        String processStatus = dto.getProcessStatus();
        BusinessPolicy one = (BusinessPolicy)((Object)this.businessPolicyRepository.getById((Serializable)((Object)dto.getBusinessNo())));
        Validate.notNull((Object)((Object)one), (String)"\u5546\u52a1\u653f\u7b56\u5ba1\u6279\u6d41\u7a0b\u56de\u8c03\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u5f53\u524d\u5b9e\u4f8b", (Object[])new Object[0]);
        BusinessPolicy audit = new BusinessPolicy();
        audit.setId(one.getId());
        if (String.valueOf(processStatus).equals(ProcessStatusEnum.PASS.getDictCode())) {
            audit.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
            this.businessPolicyRepository.updateById((Object)audit);
            log.info("\u5546\u52a1\u653f\u7b56\u5ba1\u6279\u901a\u8fc7\uff0c\u5ba1\u6279\u72b6\u6001\uff1a{}", (Object)processStatus);
        }
        if (String.valueOf(processStatus).equals(ProcessStatusEnum.REJECT.getDictCode())) {
            audit.setProcessStatus(ProcessStatusEnum.REJECT.getDictCode());
            this.businessPolicyRepository.updateById((Object)audit);
            this.returnBudget(one);
        }
        if (String.valueOf(processStatus).equals(ProcessStatusEnum.RECOVER.getDictCode())) {
            audit.setProcessStatus(ProcessStatusEnum.RECOVER.getDictCode());
            this.businessPolicyRepository.updateById((Object)audit);
            this.returnBudget(one);
        }
    }

    private void returnBudget(BusinessPolicy one) {
        BusinessPolicyDto businessPolicyDto = (BusinessPolicyDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)one, BusinessPolicyDto.class, null, null, new String[0]);
        this.businessPolicyService.returnBudget(businessPolicyDto);
    }
}

