package com.biz.crm.tpm.business.business.policy.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/5 14:24
 * @description：产品
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "商务政策dto")
public class BusinessPolicyProductDto extends TenantFlagOpDto {

    @ApiModelProperty("是否选中，0否1是")
    private String checked;

    @ApiModelProperty(name = "商务政策编码", notes = "商务政策编码")
    private String businessPolicyCode;

    /**
     * 品牌编码
     */
    @ApiModelProperty(value = "品牌编码", notes = "")
    @Deprecated
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty(value = "品牌名称", notes = "")
    @Deprecated
    private String productBrandName;

    /**
     * 品类编码
     */
    @ApiModelProperty(value = "品类编码", notes = "")
    @Deprecated
    private String productCategoryCode;

    /**
     * 品类名称
     */
    @ApiModelProperty(value = "品类名称", notes = "")
    @Deprecated
    private String productCategoryName;

    /**
     * 产品编码
     */
    @ApiModelProperty(name = "产品编码", notes = "产品编码")
    private String productCode;
    /**
     * 产品名称
     */
    @ApiModelProperty(name = "产品名称", notes = "产品名称")
    private String productName;

    @ApiModelProperty("供货价(元)")
    private BigDecimal offerGoodsPrice;

    @ApiModelProperty("预计销量(件)")
    private BigDecimal predictSaleQuantity;

    @ApiModelProperty("预计折前销售额(元)")
    private BigDecimal predictBeforeDiscountSaleAmount;

    @ApiModelProperty("旬返-点数")
    private BigDecimal tenDayReturnPoint;

    @ApiModelProperty("月返-点数")
    private BigDecimal monthReturnPoint;

    @ApiModelProperty("目标达成返点")
    private BigDecimal targetReachReturnPoint;

    @ApiModelProperty("组合装点数")
    private BigDecimal combinationPoint;

    @ApiModelProperty("基础运营点数")
    private BigDecimal baseOperationPoint;

    @ApiModelProperty("人员点数")
    private BigDecimal manPoint;

    @ApiModelProperty("投放点数")
    private BigDecimal putPoint;

    @ApiModelProperty("物流点数")
    private BigDecimal logisticPoint;

    @ApiModelProperty("季返点数")
    private BigDecimal quarterReturnPoint;

    @ApiModelProperty("年返点数")
    private BigDecimal yearReturnPoint;

    @ApiModelProperty("其他政策1-点数")
    private BigDecimal otherPolicy1Point;

    @ApiModelProperty("其他政策2-点数")
    private BigDecimal otherPolicy2Point;

    @ApiModelProperty("其他政策3-点数")
    private BigDecimal otherPolicy3Point;

    @ApiModelProperty("其他政策4-价格")
    private BigDecimal otherPolicy4Price;

    @ApiModelProperty(" 基础返点(旬返) 费用")
    private BigDecimal baseReturnPointTenDayReturnFee;

    @ApiModelProperty("基础返点(月返) 费用")
    private BigDecimal baseReturnPointMonthReturnFee;

    @ApiModelProperty("目标达成返点费用")
    private BigDecimal targetReachReturnPointFee;

    @ApiModelProperty("组合装费用")
    private BigDecimal combinationFee;

    @ApiModelProperty("基础运营费用")
    private BigDecimal baseOperationFee;

    @ApiModelProperty("人员费用")
    private BigDecimal peopleFee;

    @ApiModelProperty("投放费用")
    private BigDecimal putFee;

    @ApiModelProperty("物流支持费用")
    private BigDecimal logisticSupportFee;

    @ApiModelProperty("季返费用")
    private BigDecimal quarterReturnFee;

    @ApiModelProperty("年返费用")
    private BigDecimal yearReturnFee;

    @ApiModelProperty("其他政策1-费用")
    private BigDecimal otherPolicy1Fee;

    @ApiModelProperty("其他政策2-费用")
    private BigDecimal otherPolicy2Fee;

    @ApiModelProperty("其他政策3-费用")
    private BigDecimal otherPolicy3Fee;

    @ApiModelProperty("其他政策4-费用")
    private BigDecimal otherPolicy4Fee;

    @ApiModelProperty("费用小计")
    private BigDecimal feeTotal;
}
