package com.biz.crm.tpm.business.business.policy.sdk.event.log;

import com.biz.crm.tpm.business.business.policy.sdk.dto.log.BusinessPolicyLogEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/11 11:21
 * @description：日志监听
 */
public interface BusinessPolicyEventListener extends NebulaEvent {
    /**
     * 创建事件
     *
     * @param eventDto
     */
    void onCreate(BusinessPolicyLogEventDto eventDto);
    /**
     * 删除事件
     *
     * @param eventDto
     */
    void onDelete(BusinessPolicyLogEventDto eventDto);
    /**
     * 关闭事件
     *
     * @param eventDto
     */
    void onClose(BusinessPolicyLogEventDto eventDto);
    /**
     * 更新日志
     *
     * @param eventDto
     */
    void onUpdate(BusinessPolicyLogEventDto eventDto);
    /**
     * 启用
     *
     * @param eventDto
     */
    void onEnable(BusinessPolicyLogEventDto eventDto);
    /**
     * 禁用
     *
     * @param eventDto
     */
    void onDisable(BusinessPolicyLogEventDto eventDto);
}
