package com.biz.crm.tpm.business.business.policy.sdk.service;


import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * 商务政策主表(BusinessPolicy)表服务接口
 *
 * @author makejava
 * @since 2022-11-05 11:29:45
 */
public interface BusinessPolicyLockService {
    /**
     * 加锁
     *
     * @param code
     * @param timeUnit
     * @param time
     * @return boolean
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-09-22 14:53
     */
    boolean lock(String code, TimeUnit timeUnit, int time);

    /**
     * 加锁
     *
     * @param codeList
     * @param timeUnit
     * @param time
     * @return boolean
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-09-22 14:53
     */
    boolean lock(List<String> codeList, TimeUnit timeUnit, int time);

    /**
     * 解锁
     *
     * @param code
     * @return boolean
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-09-22 14:53
     */
    void unlock(String code);

    /**
     * 解锁
     *
     * @param codeList
     * @return boolean
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-09-22 14:53
     */
    void unlock(List<String> codeList);

}

