package com.biz.crm.tpm.business.business.policy.sdk.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.business.policy.sdk.dto.BusinessPolicyApprovalDto;
import com.biz.crm.tpm.business.business.policy.sdk.dto.BusinessPolicyDto;
import com.biz.crm.tpm.business.business.policy.sdk.vo.BusinessPolicyBudgetVo;
import com.biz.crm.tpm.business.business.policy.sdk.vo.BusinessPolicyVo;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/**
 * 商务政策主表(BusinessPolicy)表服务接口
 *
 * @author makejava
 * @since 2022-11-05 11:29:45
 */
public interface BusinessPolicyService {

    /**
     * 分页查询数据
     *
     * @param pageable       分页对象
     * @param businessPolicy 实体对象
     * @return
     */
    Page<BusinessPolicyVo> findByConditions(Pageable pageable, BusinessPolicyDto businessPolicy);

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    BusinessPolicyVo findById(String id);

    /**
     * 新增数据
     *
     * @param businessPolicy 实体对象
     * @return 新增结果
     */
    void create(BusinessPolicyDto businessPolicy);

    /**
     * 修改新据
     *
     * @param businessPolicy 实体对象
     * @return 修改结果
     */
    void update(BusinessPolicyDto businessPolicy);

    /**
     * 删除数据
     *
     * @param idList 主键结合
     * @return 删除结果
     */
    void delete(List<String> idList);

    void close(List<String> idList);

    void batchSubmitApproval(BusinessPolicyApprovalDto dto);

    /**
     * 编码查询
     *
     * @param codes
     */
    List<BusinessPolicyVo> findBusinessPolicyByCode(Set<String> codes);

    /**
     * 申请金额修改
     *
     * @param voList
     */
    void updateBusinessPolicyApplyAmount(List<BusinessPolicyVo> voList);

    /**
     * 商务政策退货预算
     * @param businessPolicyDto
     */
    void returnBudget(BusinessPolicyDto businessPolicyDto);

    /**
     * 查询预算
     *
     * @param code
     * @return
     */
    List<BusinessPolicyBudgetVo> findBusinessPolicyBudget(String code);

    /**
     * 查找完全结案的商务政策预算
     * @param commercePolicyCodes
     * @return
     */
    List<BusinessPolicyVo> findWholeAuditBusinessPolicyBudget(List<String> commercePolicyCodes);

    /**
     * 结案核销审批通过更新商务政策是否完全结案和结案金额
     * @param
     */
    void updateBusinessPolicyByAuditPass(List<BusinessPolicyDto> businessPolicyDtoList);

}

