package com.biz.crm.tpm.business.business.policy.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/5 14:41
 * @description：预算
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "BusinessPolicyBudgetVo", description = "预算")
public class BusinessPolicyBudgetVo extends TenantFlagOpVo {
    @ApiModelProperty(name = "商务政策编码", notes = "商务政策编码")
    private String businessPolicyCode;

    @ApiModelProperty(name = "预算编码", notes = "预算编码")
    private String budgetCode;

    @ApiModelProperty(name = "三级预算项目", notes = "三级预算项目")
    private String thirdBudgetCode;

    @ApiModelProperty(name = "三级预算项目可用余额", notes = "三级预算项目可用余额")
    private BigDecimal thirdBudgetAmount;

    @ApiModelProperty(name = "二级预算项目", notes = "二级预算项目")
    private String secondBudgetCode;

    @ApiModelProperty(name = "二级预算项目可用余额", notes = "二级预算项目可用余额")
    private BigDecimal secondBudgetAmount;

    @ApiModelProperty(name = "一级预算项目", notes = "一级预算项目")
    private String firstBudgetAmount;

    @ApiModelProperty(name = "年月", notes = "年月")
    private String yearAndMonth;

    @ApiModelProperty(name = "归口", notes = "归口")
    private String feeBelongCode;

    @ApiModelProperty(name = "组织", notes = "组织")
    private String orgCode;

    @ApiModelProperty(name = "组织名称", notes = "组织名称")
    private String orgName;

    @ApiModelProperty(name = "客户", notes = "客户")
    private String customerCode;

    @ApiModelProperty(name = "客户名称", notes = "客户名称")
    private String customerName;

    /**
     * 品牌编码
     */
    @ApiModelProperty(value = "品牌编码", notes = "")
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty(value = "品牌名称", notes = "")
    private String productBrandName;

    /**
     * 申请金额字符串
     */
    @ApiModelProperty(value = "申请金额字符串", notes = "")
    private String applyAmountStr;

    /**
     * 申请金额
     */
    @ApiModelProperty(value = "申请金额", notes = "")
    private BigDecimal applyAmount;

    /**
     * 预算管控可用余额
     */
    @ApiModelProperty(value = "预算管控可用余额", notes = "")
    private BigDecimal controlBalanceAmount;

    /**
     * 管控率
     */
    @ApiModelProperty(value = "管控率", notes = "")
    private BigDecimal controlRatio;

    /**
     * 费用率
     */
    @ApiModelProperty(value = "费用率", notes = "")
    private BigDecimal feeRatio;

    /**
     * 管控类型
     */
    @ApiModelProperty(value = "管控类型[数据字典:tpm_budget_control_type]", notes = "")
    private String controlTypeCode;

    /**
     * 预估销售额
     */
    @ApiModelProperty("预估销售额")
    private BigDecimal estimateSaleAmount;
}
