package com.biz.crm.tpm.business.business.policy.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/5 14:42
 * @description：政策范围
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "BusinessPolicyScopeVo", description = "政策范围")
public class BusinessPolicyScopeVo extends TenantFlagOpVo {
    @ApiModelProperty(name = "商务政策编码", notes = "商务政策编码")
    private String businessPolicyCode;

    @ApiModelProperty(name = "类型（1-客户，2-客户等级）", notes = "类型（1-客户，2-客户等级）")
    @Deprecated
    private String type;

    @ApiModelProperty(name = "客户等级", notes = "客户等级")
    private String customerGrade;

    @ApiModelProperty(name = "客户编码", notes = "客户编码")
    @Deprecated
    private String customerCode;

    @ApiModelProperty(name = "客户名称", notes = "客户名称")
    @Deprecated
    private String customerName;

    @ApiModelProperty("客户合同量")
    private String customerContractQuantity;

    @ApiModelProperty("基础返点(旬返)")
    private BigDecimal baseTenDayReturnPoint;

    @ApiModelProperty("基础返点(月返)")
    private BigDecimal baseMonthReturnPoint;

    @ApiModelProperty("目标达成返点")
    private BigDecimal targetConcludeReturnPoint;

    @ApiModelProperty("组合装点数")
    private BigDecimal combinationPoint;

    @ApiModelProperty("其他政策1-点数")
    private BigDecimal otherPolicy1Point;

    @ApiModelProperty("其他政策2-点数")
    private BigDecimal otherPolicy2Point;

    @ApiModelProperty("其他政策3-点数")
    private BigDecimal otherPolicy3Point;

    @ApiModelProperty("其他政策4-价格")
    private BigDecimal otherPolicy4Price;

    @ApiModelProperty("基础运营")
    private BigDecimal baseOperation;

    @ApiModelProperty("人员费用")
    private BigDecimal peopleFee;

    @ApiModelProperty("投放费用")
    private BigDecimal putFee;

    @ApiModelProperty("物流费用")
    private BigDecimal logisticsFee;

    @ApiModelProperty("季度返")
    private BigDecimal quarterReturn;

    @ApiModelProperty("年返兑现")
    private BigDecimal yearReturnCash;
}
