package com.biz.crm.tpm.business.business.policy.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/5 11:31
 * @description：商务政策vo
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "BusinessPolicyVo", description = "商务政策vo")
public class BusinessPolicyVo extends TenantFlagOpVo {
    @ApiModelProperty(name = "商务政策编码", notes = "商务政策编码")
    private String businessPolicyCode;

    @ApiModelProperty(name = "商务政策名称", notes = "商务政策名称")
    private String businessPolicyName;

    @ApiModelProperty(name = "政策开始时间", notes = "政策开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date policyBeginTime;

    @ApiModelProperty(name = "政策结束时间", notes = "政策结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date policyEndTime;

    @ApiModelProperty(name = "审批状态", notes = "审批状态")
    private String processStatus;

    @ApiModelProperty(name = "申请金额", notes = "申请金额")
    private BigDecimal applyAmount;

    @ApiModelProperty("流程编码")
    private String processNo;

    @ApiModelProperty(name = "预算", notes = "预算")
    private List<BusinessPolicyBudgetVo> businessPolicyBudgetVoList;

//    @ApiModelProperty(name = "产品", notes = "产品")
//    private List<BusinessPolicyProductVo> businessPolicyProductVoList;

    @ApiModelProperty(name = "政策范围", notes = "政策范围")
    private List<BusinessPolicyScopeVo> businessPolicyScopeVoList;

    @ApiModelProperty("已使用金额")
    private BigDecimal alreadyUseAmount;

    @ApiModelProperty("已结案金额")
    private BigDecimal alreadyAuditAmount;

    @ApiModelProperty("是否完全结案")
    private String wholeAudit;

}
