package com.biz.crm.tpm.business.third.system.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.third.system.a.pallet.goods.dto.APalletGoodsTransferDto;
import com.biz.crm.tpm.business.third.system.feign.impl.TpmProfitabilityAnalysisFeignImpl;
import com.biz.crm.tpm.business.third.system.sdk.dto.APalletGoodsDto;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author liyang
 * @date 2024/04/10
 */
@FeignClient(
    name = "${mdm.feign-client.name:crm-tpm}",
    path = "crm-tpm",
    fallbackFactory = TpmProfitabilityAnalysisFeignImpl.class)
public interface APalletGoodsServiceFeign {

  @ApiOperation(value = "一盘货:费用预算划拨调整申请")
  @GetMapping("/v1/aPalletGoods/feeAdjustApply")
  Result feeAdjustApply(@RequestBody APalletGoodsTransferDto<APalletGoodsDto> dto);
}
