package com.biz.crm.tpm.business.third.system.feign.impl;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.third.system.a.pallet.goods.dto.APalletGoodsTransferDto;
import com.biz.crm.tpm.business.third.system.feign.APalletGoodsServiceFeign;
import com.biz.crm.tpm.business.third.system.sdk.dto.APalletGoodsDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * @author liyang
 * @date 2024/04/10
 */
@Component
@Slf4j
public class APalletGoodsServiceFeignImpl implements FallbackFactory<APalletGoodsServiceFeign> {

  @Override
  public APalletGoodsServiceFeign create(Throwable cause) {
    return new APalletGoodsServiceFeign(){

      @Override
      public Result feeAdjustApply(APalletGoodsTransferDto<APalletGoodsDto> dto) {
        throw new UnsupportedOperationException("一盘货:费用预算划拨调整申请熔断");
      }
    };
  }
}
