package com.biz.crm.tpm.business.third.system.feign.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.third.system.sdk.dto.TpmZtfi099ForEctQueryDto;
import com.biz.crm.tpm.business.third.system.feign.TpmProfitabilityAnalysisFeign;
import com.biz.crm.tpm.business.third.system.sdk.vo.TpmProfitabilityAnalysisVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Author: cjl
 * @Date 2023/7/21
 */
@Component
@Slf4j
public class TpmProfitabilityAnalysisFeignImpl implements FallbackFactory<TpmProfitabilityAnalysisFeign> {

    @Override
    public TpmProfitabilityAnalysisFeign create(Throwable cause) {
        return new TpmProfitabilityAnalysisFeign(){
            @Override
            public Result<Page<TpmProfitabilityAnalysisVo>> findData4Ect(Pageable pageable, TpmZtfi099ForEctQueryDto ectZtfi099QueryDto) {
                throw new UnsupportedOperationException("分页查询数据熔断");
            }
        };
    }
}
