package com.biz.crm.tpm.business.third.system.service.impl;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.third.system.a.pallet.goods.dto.APalletGoodsTransferDto;
import com.biz.crm.tpm.business.third.system.feign.APalletGoodsServiceFeign;
import com.biz.crm.tpm.business.third.system.sdk.dto.APalletGoodsDto;
import com.biz.crm.tpm.business.third.system.sdk.service.APalletGoodsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

/**
 * @author liyang
 * @date 2024/04/10
 */
@Service
public class APalletGoodsServiceImpl implements APalletGoodsService {

  @Autowired(required = false)
  private APalletGoodsServiceFeign aPalletGoodsServiceFeign;

  @Override
  public void feeAdjustApply(APalletGoodsTransferDto<APalletGoodsDto> dto) {
    Assert.notNull(dto, "传入数据空");
    Assert.notEmpty(dto.getItemList(), "传入数据空");
    Result result = aPalletGoodsServiceFeign.feeAdjustApply(dto);
    Assert.isTrue(result.isSuccess(), result.getMessage());
  }

  @Override
  public void adjustStatusFeedback(APalletGoodsDto aPalletGoodsDto) {
    return;
  }
}
