/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.third.system.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.third.system.local.service.Ce1MnjtService;
import com.biz.crm.tpm.business.third.system.local.service.PullCeSalesDataService;
import com.biz.crm.tpm.business.third.system.sdk.dto.Ce1ExamineCircularSearchDto;
import com.biz.crm.tpm.business.third.system.sdk.dto.Ce1MnjtFullDto;
import com.biz.crm.tpm.business.third.system.sdk.vo.Ce1ExamineCircularSearchVo;
import com.biz.crm.tpm.business.third.system.sdk.vo.Ce1MnjtFullVo2;
import com.biz.crm.tpm.business.third.system.sdk.vo.PlatformPriceVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u7535\u5546\u65e5\u9500\u552e\u6570\u636e\u62a5\u8868"})
@RequestMapping(value={"/v1/ce1"})
public class Ce1Controller {
    private static final Logger log = LoggerFactory.getLogger(Ce1Controller.class);
    @Autowired(required=false)
    private Ce1MnjtService ce1MnjtService;
    @Autowired(required=false)
    private PullCeSalesDataService pullCeSaleDataTaskService;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7535\u5546\u65e5\u9500\u552e\u6570\u636e\u62a5\u8868")
    @GetMapping(value={"findDaySalesByConditions"})
    public Result<Page<Ce1MnjtFullVo2>> findDaySalesByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="salesPlanDto", value="\u7535\u5546\u65e5\u9500\u552e\u6570\u636e") Ce1MnjtFullDto dto) {
        try {
            Page<Ce1MnjtFullVo2> page = this.ce1MnjtService.findDaySalesByConditions(pageable, dto);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5e73\u53f0\u4ef7\u683c\u5bf9\u6bd4\u62a5\u8868")
    @GetMapping(value={"findPlatformPriceConditions"})
    public Result<Page<PlatformPriceVo>> findPlatformPriceConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="salesPlanDto", value="\u7535\u5546\u65e5\u9500\u552e\u6570\u636e") Ce1MnjtFullDto dto) {
        try {
            Page<PlatformPriceVo> page = this.ce1MnjtService.findPlatformPriceConditions(pageable, dto);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8003\u52e4\u901a\u62a5\u7ba1\u7406\u67e5\u8be2\u5206\u644a\u6570\u636e")
    @GetMapping(value={"findExamineCircularDataList"})
    public Result<List<Ce1ExamineCircularSearchVo>> findExamineCircularDataList(@ApiParam(name="Ce1ExamineCircularSearchDto", value="\u8003\u52e4\u901a\u62a5\u7ba1\u7406\u67e5\u8be2\u5206\u644a\u6570\u636e\u6761\u4ef6") Ce1ExamineCircularSearchDto dto, @ApiParam(name="cacheKey", value="\u7f13\u5b58key(UUID+\u4e1a\u52a1\u5355\u5143\u7f16\u7801)") @RequestParam String cacheKey) {
        try {
            return Result.ok(this.ce1MnjtService.findExamineCircularDataList(dto, cacheKey));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65e5\u9500\u552e\u62a5\u8868\u624b\u52a8\u62c9\u53d6")
    @GetMapping(value={"dailySalesReport"})
    public Result<?> dailySalesReport(@RequestParam(value="ds") String ds, @RequestParam(value="createDate", required=false) String createDate) {
        try {
            boolean hasLock;
            if (StringUtils.isEmpty((CharSequence)ds)) {
                ds = DateUtil.format((Date)DateUtil.dateAddDay((Date)new Date(), (Integer)-1), (String)"yyyyMMdd");
            }
            if (hasLock = this.redisService.hasKey("pull:sales_data:lock:" + ds).booleanValue()) {
                return Result.error((String)"\u4e0a\u6b21\u62c9\u53d6\u8fd8\u672a\u5b8c\u6210,\u8bf7\u8010\u6027\u7b49\u5f85!");
            }
            this.pullCeSaleDataTaskService.pullSalesDataReportAsync(ds, createDate, this.loginUserService.getAbstractLoginUser());
            return Result.ok();
        }
        catch (Exception e) {
            log.error("\u65e5\u9500\u552e\u62a5\u8868\u62c9\u53d6\u5f02\u5e38:{}", (Object)e.getMessage());
            return Result.error((String)e.getMessage());
        }
    }
}

