/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.third.system.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.dataphin.sdk.service.DataPhinZmsd121Service;
import com.biz.crm.mn.third.system.dataphin.sdk.service.DataPhinZmsd187Service;
import com.biz.crm.mn.third.system.dataphin.sdk.vo.Zmsd121Vo;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.dto.AccountCheckBillDto;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.dto.ContractDocumentDto;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.service.ElectronicSignatureApiService;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.vo.CreateContractVo;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.vo.ElectronicSignatureVo;
import com.biz.crm.mn.third.system.red.packet.sdk.dto.RedPacketQuerySchemeDto;
import com.biz.crm.mn.third.system.red.packet.sdk.service.RedPacketService;
import com.biz.crm.mn.third.system.red.packet.sdk.vo.RedPacketQuerySchemeVo;
import com.biz.crm.tpm.business.third.system.local.service.PullFeePoolDataService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import jodd.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u624b\u52a8\u8c03\u7528\u7b2c\u4e09\u65b9\u76f8\u5173\u63a5\u53e3"})
@RequestMapping(value={"/v1/manualController"})
public class ManualController {
    private static final Logger log = LoggerFactory.getLogger(ManualController.class);
    @Autowired
    private ElectronicSignatureApiService electronicSignatureApiService;
    @Autowired(required=false)
    private RedPacketService redPacketService;
    @Autowired(required=false)
    private PullFeePoolDataService pullFeePoolDataService;
    @Autowired(required=false)
    private DataPhinZmsd187Service dataPhinZmsd187Service;
    @Autowired(required=false)
    private DataPhinZmsd121Service dataPhinZmsd121Service;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private RedisService redisService;

    @PostMapping(value={"pushAccountCheckBillTest"})
    public ElectronicSignatureVo<CreateContractVo> test(@RequestBody AccountCheckBillDto dto) {
        ContractDocumentDto contractDocumentDto = dto.getContractDocumentDto();
        File file = new File(dto.getContractDto().getCustomerCode());
        contractDocumentDto.setAccountCheckBillFile(file);
        return this.electronicSignatureApiService.pushAccountCheckBill(dto);
    }

    @PostMapping(value={"testRedPacket"})
    public Result<List<RedPacketQuerySchemeVo>> testRedPacket(@RequestBody RedPacketQuerySchemeDto dto) {
        return Result.ok((Object)this.redPacketService.redPacketQueryScheme(dto));
    }

    @PostMapping(value={"test187"})
    public Result<?> test187(Integer pageNum, Integer pageSize, String ds, String accountingPeriod) {
        return Result.ok((Object)this.dataPhinZmsd187Service.getZmsd187Data(ds, accountingPeriod, pageNum, pageSize));
    }

    @PostMapping(value={"test121"})
    public Result<?> test121(Integer pageNum, Integer pageSize, String ds, String accountingPeriod) {
        return Result.ok((Object)this.dataPhinZmsd121Service.getZmsd121Data(ds, accountingPeriod, pageNum, pageSize));
    }

    @ApiOperation(value="\u624b\u52a8\u62c9\u53d6\u8d39\u7528\u6c60\u4f59\u989d\u6570\u636e\u63a5\u53e3", notes="")
    @PostMapping(value={"manualFeePool"})
    public Result<?> manualFeePool(@RequestBody Zmsd121Vo vo) {
        boolean lock = this.redisService.hasKey("pull:fee_pool_data:lock");
        if (lock) {
            return Result.error((String)"\u4e0a\u6b21\u62c9\u53d6\u5c1a\u672a\u5b8c\u6210,\u8bf7\u8010\u6027\u7b49\u5f85!");
        }
        try {
            String accountingPeriod;
            String ds = vo.getDs();
            if (StringUtil.isEmpty((CharSequence)ds)) {
                Calendar calendar = Calendar.getInstance();
                calendar.set(5, 1);
                ds = DateUtil.format((Date)calendar.getTime(), (String)"yyyyMMdd");
            }
            if (StringUtil.isEmpty((CharSequence)(accountingPeriod = vo.getAccounting_period()))) {
                int month = Integer.parseInt(ds.substring(4, 6));
                month = month == 1 ? 12 : --month;
                accountingPeriod = String.format("%02d", month);
            }
            this.pullFeePoolDataService.pullFeePoolDataAsync(ds, accountingPeriod, this.loginUserService.getAbstractLoginUser());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return Result.error((String)e.getMessage());
        }
        return Result.ok();
    }
}

