/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.third.system.local.export;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.third.system.local.service.Ce1MnjtService;
import com.biz.crm.tpm.business.third.system.sdk.dto.Ce1MnjtFullDto;
import com.biz.crm.tpm.business.third.system.sdk.vo.Ce1MnjtExportVo;
import com.biz.crm.tpm.business.third.system.sdk.vo.Ce1MnjtFullVo2;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class Ce1MnjtExportProcess
implements ExportProcess<Ce1MnjtExportVo> {
    private static final Logger log = LoggerFactory.getLogger(Ce1MnjtExportProcess.class);
    @Autowired(required=false)
    private Ce1MnjtService ce1MnjtService;

    public Integer getTotal(Map<String, Object> params) {
        PageRequest pageable = PageRequest.of((int)1, (int)1);
        Page<Ce1MnjtFullVo2> page = this.ce1MnjtService.findDaySalesByConditions((Pageable)pageable, this.convertParams(params));
        Integer total = (int)page.getTotal();
        Validate.isTrue((total < CommonConstant.IE_EXPORT_MAX_TOTAL ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"), (Object[])new Object[0]);
        return total;
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        if (vo.getPageNo() == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef");
        }
        vo.setPageNo(Integer.valueOf(vo.getPageNo() + 1));
        Page<Ce1MnjtFullVo2> page = this.ce1MnjtService.findDaySalesByConditions((Pageable)PageRequest.of((int)vo.getPageNo(), (int)this.getPageSize()), this.convertParams(params));
        return JSONArray.parseArray((String)JSON.toJSONString((Object)page.getRecords()));
    }

    public String getBusinessCode() {
        return "TPM_CE1_MNJT_EXPORT";
    }

    public String getBusinessName() {
        return "TPM_\u7535\u5546\u65e5\u9500\u552e\u6570\u636e\u5bfc\u51fa";
    }

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    private Ce1MnjtFullDto convertParams(Map<String, Object> params) {
        params.remove("sort");
        params.remove("europaInfoCode");
        Map<String, Object> map = params.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a));
        return (Ce1MnjtFullDto)JSON.parseObject((String)JSON.toJSONString(map), Ce1MnjtFullDto.class);
    }
}

