/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.third.system.local.export;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.third.system.local.service.Ce1MnjtService;
import com.biz.crm.tpm.business.third.system.sdk.dto.Ce1MnjtFullDto;
import com.biz.crm.tpm.business.third.system.sdk.vo.PlatformPriceExportVo;
import com.biz.crm.tpm.business.third.system.sdk.vo.PlatformPriceVo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class PlatformPriceExportProcess
implements ExportProcess<PlatformPriceExportVo> {
    private static final Logger log = LoggerFactory.getLogger(PlatformPriceExportProcess.class);
    @Autowired(required=false)
    private Ce1MnjtService ce1MnjtService;

    public Integer getTotal(Map<String, Object> params) {
        Ce1MnjtFullDto dto;
        params = this.convertEuropaParam(params);
        PageRequest pageable = PageRequest.of((int)1, (int)1);
        Page<PlatformPriceVo> pageResult = this.ce1MnjtService.findPlatformPriceConditions((Pageable)pageable, dto = this.convertParams(params));
        Validate.isTrue((pageResult.getTotal() < (long)CommonConstant.IE_EXPORT_MAX_TOTAL.intValue() ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"), (Object[])new Object[0]);
        return Long.valueOf(pageResult.getTotal()).intValue();
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        Ce1MnjtFullDto dto;
        params = this.convertEuropaParam(params);
        PageRequest pageable = PageRequest.of((int)(vo.getPageNo() + 1), (int)this.getPageSize());
        Page<PlatformPriceVo> pageResult = this.ce1MnjtService.findPlatformPriceConditions((Pageable)pageable, dto = this.convertParams(params));
        if (CollectionUtils.isEmpty((Collection)pageResult.getRecords())) {
            return new JSONArray();
        }
        List records = pageResult.getRecords();
        return JSON.parseArray((String)JSON.toJSONString((Object)records, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
    }

    public String getBusinessCode() {
        return "PLATFORM_PRICE_EXPORT";
    }

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    private Ce1MnjtFullDto convertParams(Map<String, Object> params) {
        return (Ce1MnjtFullDto)JSON.parseObject((String)JSON.toJSONString(params), Ce1MnjtFullDto.class);
    }

    public String getBusinessName() {
        return "\u5e73\u53f0\u4ef7\u683c\u5bf9\u6bd4\u8868";
    }
}

