/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.third.system.local.job;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.third.system.local.repository.Ce1MnLockRepository;
import com.biz.crm.tpm.business.third.system.local.service.Ce1MnLockService;
import com.biz.crm.tpm.business.third.system.local.service.PullCeSalesDataService;
import com.biz.crm.tpm.business.third.system.sdk.constants.CeConstant;
import com.biz.crm.tpm.business.third.system.sdk.dto.Ce1MnLockDto;
import com.biz.crm.tpm.business.third.system.sdk.vo.Ce1MnLockVo;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import jodd.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PullCeSalesDataAutoSyncXxlJob {
    private static final Logger log = LoggerFactory.getLogger(PullCeSalesDataAutoSyncXxlJob.class);
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private PullCeSalesDataService pullCeSalesDataService;
    @Autowired(required=false)
    private Ce1MnLockRepository ce1MnLockRepository;
    @Autowired(required=false)
    private Ce1MnLockService ce1MnLockService;

    @DynamicTaskService(cornExpression="0 20 6 * * ?", taskDesc="\u7535\u5546\u65e5\u9500\u552e\u62a5\u8868SAP")
    public void pullSalesDataDay() {
        this.loginUserService.refreshAuthentication(null);
        String ds = DateUtil.format((Date)DateUtil.dateAddDay((Date)new Date(), (Integer)-1), (String)"yyyyMMdd");
        log.info("=====>    \u7535\u5546\u65e5\u9500\u552e\u62a5\u8868\u6267\u884c\u5b9a\u65f6\u4efb\u52a1ds[{}] <=====", (Object)ds);
        Ce1MnLockVo vo = new Ce1MnLockVo();
        vo.setDs(ds);
        vo.setCurrentPageNumber(Integer.valueOf(0));
        this.pullCeSalesDataService.pullSalesDataReport(vo);
        log.info("=====>    \u7535\u5546\u65e5\u9500\u552e\u62a5\u8868\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5ds[{}] <=====", (Object)ds);
    }

    @DynamicTaskService(cornExpression="0 10 0 2-4 * ?", taskDesc="\u7535\u5546\u65e5\u9500\u552e\u62a5\u8868\u62c9\u53d6\u6574\u6708\u6570\u636e")
    public void pullSalesDataMonth() {
        this.loginUserService.refreshAuthentication(null);
        String ds = DateUtil.format((Date)DateUtil.getLastDayOfLastMonth(), (String)"yyyyMMdd");
        log.info("=====>    \u7535\u5546\u65e5\u9500\u552e\u62a5\u8868\u62c9\u53d6\u6574\u6708\u6570\u636e\uff0c\u6267\u884c\u5b9a\u65f6\u4efb\u52a1ds[{}]    <=====", (Object)ds);
        Ce1MnLockVo vo = new Ce1MnLockVo();
        vo.setDs(ds);
        vo.setCurrentPageNumber(Integer.valueOf(0));
        this.pullCeSalesDataService.pullSalesDataReport(vo);
        log.info("=====>    \u7535\u5546\u65e5\u9500\u552e\u62a5\u8868\u62c9\u53d6\u6574\u6708\u6570\u636e\uff0c\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5ds[{}]    <=====", (Object)ds);
    }

    @DynamicTaskService(cornExpression="0 20 0/1 * * ?", taskDesc="\u7535\u5546\u65e5\u9500\u552e\u62a5\u8868\u62c9\u53d6\u6570\u636e\u8865\u507f\u673a\u5236")
    public void pullSalesDataRetry() {
        this.loginUserService.refreshAuthentication(null);
        this.removeExpireTimeData();
        log.info("=====>    \u7535\u5546\u65e5\u9500\u552e\u62a5\u8868\u62c9\u53d6\u6570\u636e\u8865\u507f\u673a\u5236\uff0c\u6267\u884c\u5b9a\u65f6\u4efb\u52a1 start    <=====");
        PageRequest pageable = PageRequest.of((int)1, (int)15);
        Page<Ce1MnLockVo> mnLockVoPage = null;
        do {
            mnLockVoPage = this.ce1MnLockService.findByConditions((Pageable)pageable, new Ce1MnLockDto());
            pageable = pageable.next();
            if (CollectionUtil.isEmpty((Collection)mnLockVoPage.getRecords())) {
                log.info("=====>    \u7535\u5546\u65e5\u9500\u552e\u62a5\u8868\u62c9\u53d6\u6570\u636e\u8865\u507f\u673a\u5236\uff0c\u65e0\u9700\u8865\u507f    <=====");
                return;
            }
            mnLockVoPage.getRecords().forEach(item -> {
                String ds = item.getDs();
                item.setRetryTime(Optional.ofNullable(item.getRetryTime()).orElse(0));
                log.info("=====>    \u7535\u5546\u65e5\u9500\u552e\u62a5\u8868\u62c9\u53d6\u6570\u636e\u8865\u507f\u673a\u5236\uff0c\u6267\u884c\u5b9a\u65f6\u4efb\u52a1ds[{}] [{}]  start  <=====", (Object)ds, (Object)JSON.toJSONString((Object)item));
                if (CeConstant.PULL_SALES_DATA_MAX_RETRY_TIME < item.getRetryTime()) {
                    this.removeRetrySuccess(item.getId());
                    log.info("=====>    \u7535\u5546\u65e5\u9500\u552e\u62a5\u8868\u62c9\u53d6\u6570\u636e\u8865\u507f\u673a\u5236\uff0c\u6267\u884c\u5b9a\u65f6\u4efb\u52a1ds[{}] \u5df2\u8d85\u8fc7\u6700\u5927\u91cd\u8bd5\u6b21\u6570[{}]; [{}]  end  <=====", new Object[]{ds, CeConstant.PULL_SALES_DATA_MAX_RETRY_TIME, JSON.toJSONString((Object)item)});
                    return;
                }
                try {
                    this.pullCeSalesDataService.pullSalesDataReport((Ce1MnLockVo)item);
                    this.removeRetrySuccess(item.getId());
                }
                catch (Exception e) {
                    log.info("=====>    \u7535\u5546\u65e5\u9500\u552e\u62a5\u8868\u62c9\u53d6\u6570\u636e\u8865\u507f\u673a\u5236\uff0c\u6267\u884c\u5b9a\u65f6\u4efb\u52a1ds[{}] [{}]  \u5f02\u5e38  <=====", (Object)ds, (Object)JSON.toJSONString((Object)item));
                    log.error("", (Throwable)e);
                }
                log.info("=====>    \u7535\u5546\u65e5\u9500\u552e\u62a5\u8868\u62c9\u53d6\u6570\u636e\u8865\u507f\u673a\u5236\uff0c\u6267\u884c\u5b9a\u65f6\u4efb\u52a1ds[{}] [{}]  end  <=====", (Object)ds, (Object)JSON.toJSONString((Object)item));
            });
        } while (mnLockVoPage.hasNext() && pageable.getPageNumber() < 100);
        log.info("=====>    \u7535\u5546\u65e5\u9500\u552e\u62a5\u8868\u62c9\u53d6\u6570\u636e\u8865\u507f\u673a\u5236\uff0c\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5 end    <=====");
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED, rollbackFor={Exception.class})
    public void removeExpireTimeData() {
        this.ce1MnLockRepository.removeExpireTime();
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED, rollbackFor={Exception.class})
    public void removeRetrySuccess(String id) {
        if (StringUtil.isEmpty((CharSequence)id)) {
            return;
        }
        this.ce1MnLockRepository.removeById((Serializable)((Object)id));
    }
}

