/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.third.system.local.service.impl;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.third.system.a.pallet.goods.dto.APalletGoodsTransferDto;
import com.biz.crm.mn.third.system.a.pallet.goods.service.APalletGoodsTransferService;
import com.biz.crm.tpm.business.third.system.local.entity.APalletGoods;
import com.biz.crm.tpm.business.third.system.local.repository.APalletGoodsRepository;
import com.biz.crm.tpm.business.third.system.sdk.dto.APalletGoodsDto;
import com.biz.crm.tpm.business.third.system.sdk.service.APalletGoodsService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class APalletGoodsServiceImpl
implements APalletGoodsService {
    private static final Logger log = LoggerFactory.getLogger(APalletGoodsServiceImpl.class);
    @Autowired(required=false)
    private APalletGoodsRepository aPalletGoodsRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private APalletGoodsTransferService aPalletGoodsTransferService;

    @Transactional(rollbackFor={Exception.class})
    public void feeAdjustApply(APalletGoodsTransferDto<APalletGoodsDto> dto) {
        log.info("APalletGoodsServiceImpl:feeAdjustApply{}", (Object)JSON.toJSONString(dto));
        Validate.notNull(dto, (String)"\u4f20\u5165\u6570\u636e\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((Collection)dto.getItemList(), (String)"\u4f20\u5165\u6570\u636e\u7a7a", (Object[])new Object[0]);
        if (CollectionUtils.isNotEmpty((Collection)dto.getItemList())) {
            Collection list = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getItemList(), APalletGoodsDto.class, APalletGoods.class, HashSet.class, ArrayList.class, new String[0]);
            list = list.stream().peek(e -> {
                e.setTenantCode(TenantUtils.getTenantCode());
                e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            }).collect(Collectors.toList());
            this.aPalletGoodsRepository.saveBatch(list);
        }
    }

    public void adjustStatusFeedback(APalletGoodsDto aPalletGoodsDto) {
        APalletGoodsTransferDto dto = new APalletGoodsTransferDto();
        dto.setItemList((List)Lists.newArrayList((Object[])new APalletGoodsDto[]{aPalletGoodsDto}));
        this.aPalletGoodsTransferService.adjustStatusFeedback(dto);
    }
}

