/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.third.system.local.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.enums.SalesOrgLevelTypeEnum;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.tpm.business.third.system.local.entity.Ce1MnjtInfo;
import com.biz.crm.tpm.business.third.system.local.mapper.Ce1MnjtInfoMapper;
import com.biz.crm.tpm.business.third.system.local.mapper.Ce1MnjtMapper;
import com.biz.crm.tpm.business.third.system.local.service.Ce1MnjtInfoService;
import com.biz.crm.tpm.business.third.system.local.service.Ce1MnjtService;
import com.biz.crm.tpm.business.third.system.sdk.dto.Ce1ExamineCircularSearchDto;
import com.biz.crm.tpm.business.third.system.sdk.dto.Ce1MnjtFullDto;
import com.biz.crm.tpm.business.third.system.sdk.dto.Ce1MnjtSearchDto;
import com.biz.crm.tpm.business.third.system.sdk.service.Ce1MnjtSdkService;
import com.biz.crm.tpm.business.third.system.sdk.vo.Ce1ExamineCircularSearchVo;
import com.biz.crm.tpm.business.third.system.sdk.vo.Ce1MnjtFullVo2;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class Ce1MnjtSdkServiceImpl
implements Ce1MnjtSdkService {
    private static final Logger log = LoggerFactory.getLogger(Ce1MnjtSdkServiceImpl.class);
    @Autowired(required=false)
    private Ce1MnjtService ce1MnjtService;
    @Autowired(required=false)
    private Ce1MnjtInfoService ce1MnjtInfoService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private Ce1MnjtMapper ce1MnjtMapper;
    @Autowired(required=false)
    private Ce1MnjtInfoMapper ce1MnjtInfoMapper;

    public List<Ce1MnjtFullVo2> findDataByIds(List<String> ids) {
        return this.ce1MnjtService.findDataByIds(ids);
    }

    public List<Ce1MnjtFullVo2> findCe1DataByCodes(Page<Ce1MnjtFullVo2> page, List<String> verifyCodes, Integer codeType) {
        return this.ce1MnjtService.findCe1DataByCode(page, verifyCodes, codeType);
    }

    public Page<Ce1MnjtFullVo2> findDataPage(Pageable pageable, String ds) {
        return this.ce1MnjtService.findDataPage(pageable, ds);
    }

    public Integer getCeqMnjtTotal(String ds) {
        return this.ce1MnjtService.getCe1MnjtTotal(ds);
    }

    public List<Ce1MnjtFullVo2> findDataByCustomerCodeAndDatas(String customerCode, String productCode, List<String> datas) {
        return this.ce1MnjtService.findDataByCustomerCodeAndDate(customerCode, productCode, datas);
    }

    public List<Ce1MnjtFullVo2> findListByCondition(Ce1MnjtFullDto dto) {
        if (Objects.nonNull(dto)) {
            return this.ce1MnjtService.findListByCondition(dto);
        }
        return com.google.common.collect.Lists.newArrayList();
    }

    public long findPageTotalByCondition(Ce1MnjtFullDto ce1MnjtFullDto) {
        return this.ce1MnjtService.findPageTotalByCondition(ce1MnjtFullDto);
    }

    public Page<Ce1MnjtFullVo2> findPageByCondition(Page<Ce1MnjtFullVo2> page, Ce1MnjtFullDto ce1MnjtFullDto) {
        Page<Ce1MnjtFullVo2> pageResult = this.ce1MnjtService.findPageByCondition(page, ce1MnjtFullDto);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pageResult.getRecords())) {
            List<String> cids = pageResult.getRecords().stream().map(Ce1MnjtFullVo2::getCId).collect(Collectors.toList());
            List<Ce1MnjtFullVo2> infoList = this.ce1MnjtInfoService.findByCids(cids);
            Map infoMap = infoList.stream().collect(Collectors.toMap(Ce1MnjtFullVo2::getTpmCe1MnjtId, Function.identity()));
            for (Ce1MnjtFullVo2 record : pageResult.getRecords()) {
                Ce1MnjtFullVo2 ce1MnjtFullVo2 = (Ce1MnjtFullVo2)infoMap.get(record.getCId());
                record.setSalesIncludingTaxNet(ce1MnjtFullVo2.getSalesIncludingTaxNet());
            }
        }
        return pageResult;
    }

    public List<Ce1ExamineCircularSearchVo> findExamineCircularDataList(Ce1ExamineCircularSearchDto dto, String cacheKey) {
        if (StringUtils.isNotEmpty((CharSequence)dto.getStartDate()) && StringUtils.isNotEmpty((CharSequence)dto.getEndDate())) {
            Validate.isTrue((boolean)StringUtils.equals((CharSequence)dto.getStartDate().substring(0, 7), (CharSequence)dto.getEndDate().substring(0, 7)), (String)"\u67e5\u8be2\u65f6\u95f4\u4e0d\u80fd\u8de8\u6708\uff01", (Object[])new Object[0]);
        }
        if (StringUtils.isNotEmpty((CharSequence)(cacheKey = "TPM:EXAMINE_SALES_DATE_SPLIT:" + cacheKey))) {
            this.redisService.del(cacheKey);
        }
        if (StringUtils.isEmpty((CharSequence)dto.getSaleOrgCode()) || StringUtils.isEmpty((CharSequence)dto.getCustomerCode()) || StringUtils.isEmpty((CharSequence)dto.getStartDate()) || StringUtils.isEmpty((CharSequence)dto.getEndDate())) {
            return Lists.newArrayList();
        }
        List customerVos = this.customerVoService.findByCustomerCodes((List)com.google.common.collect.Lists.newArrayList((Object[])new String[]{dto.getCustomerCode()}));
        Validate.notEmpty((Collection)customerVos, (String)"\u5ba2\u6237\u7f16\u7801[%s]\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff01", (Object[])new Object[]{dto.getCustomerCode()});
        List salesOrgVos = this.salesOrgVoService.findAllParentBySalesOrgCode(dto.getSaleOrgCode());
        salesOrgVos = salesOrgVos.stream().filter(e -> StringUtils.equals((CharSequence)SalesOrgLevelTypeEnum.MECHANISM.getCode(), (CharSequence)e.getSalesOrgLevel())).collect(Collectors.toList());
        Validate.notEmpty(salesOrgVos, (String)"\u9500\u552e\u7ec4\u7ec7\u7f16\u7801[%s]\uff0c\u672a\u67e5\u8be2\u5230\u9500\u552e\u516c\u53f8\uff01", (Object[])new Object[]{dto.getSaleOrgCode()});
        String companyCode = ((SalesOrgVo)salesOrgVos.get(0)).getErpCode();
        dto.setSaleOrgCode(companyCode);
        dto.setCustomerCode(((CustomerVo)customerVos.get(0)).getErpCode());
        dto.setStartDate(dto.getStartDate().replaceAll("-", ""));
        dto.setEndDate(dto.getEndDate().replaceAll("-", ""));
        List<Ce1MnjtFullVo2> dataList = this.ce1MnjtMapper.findExamineCircularDataList(dto);
        ArrayList<Ce1ExamineCircularSearchVo> list = new ArrayList();
        if (CollectionUtils.isNotEmpty(dataList)) {
            List productCodeList = dataList.stream().map(Ce1MnjtFullVo2::getProductCode).distinct().collect(Collectors.toList());
            List productVoList = this.productVoService.findMainDetailsByProductCodes(productCodeList);
            Map<String, ProductVo> productMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, v -> v, (v1, v2) -> v2));
            List idList = dataList.stream().flatMap(o -> Arrays.stream(o.getCids().split(","))).collect(Collectors.toList());
            List ce1Infos = this.ce1MnjtInfoMapper.selectList((Wrapper)Wrappers.lambdaQuery(Ce1MnjtInfo.class).in(Ce1MnjtInfo::getTpmCe1MnjtId, idList));
            Map ce1InfoMap = ce1Infos.stream().collect(Collectors.toMap(Ce1MnjtInfo::getTpmCe1MnjtId, Function.identity()));
            BigDecimal salesIncludingTaxNet = BigDecimal.ZERO;
            for (Ce1MnjtFullVo2 v3 : dataList) {
                String[] idArr;
                for (String id : idArr = v3.getCids().split(",")) {
                    Ce1MnjtInfo ce1MnjtInfo = (Ce1MnjtInfo)ce1InfoMap.get(id);
                    if (ce1MnjtInfo == null || !Objects.nonNull(ce1MnjtInfo.getSalesIncludingTaxNet())) continue;
                    salesIncludingTaxNet = salesIncludingTaxNet.add(new BigDecimal(ce1MnjtInfo.getSalesIncludingTaxNet()));
                }
                Ce1ExamineCircularSearchVo searchVo = new Ce1ExamineCircularSearchVo();
                searchVo.setProductCode(v3.getProductCode());
                if (productMap.containsKey(v3.getProductCode())) {
                    ProductVo productVo = productMap.get(v3.getProductCode());
                    searchVo.setProductName(productVo.getProductName());
                    searchVo.setProductBrandCode(productVo.getProductBrandCode());
                    searchVo.setProductBrandName(productVo.getProductBrandName());
                    searchVo.setProductLevelCode(productVo.getProductCategoryCode());
                    searchVo.setProductLevelName(productVo.getProductCategoryName());
                    searchVo.setSubProductLevelCode(productVo.getProductLevelCode());
                    searchVo.setSubProductLevelName(productVo.getProductLevelName());
                }
                searchVo.setSplitAmount(salesIncludingTaxNet);
                searchVo.setProductCode(searchVo.getProductCode());
                list.add(searchVo);
            }
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(list = list.stream().filter(e -> Objects.nonNull(e.getSplitAmount()) && BigDecimal.ZERO.compareTo(e.getSplitAmount()) < 0).collect(Collectors.toList())) && StringUtils.isNotEmpty((CharSequence)cacheKey)) {
            Map<String, BigDecimal> map = list.stream().collect(Collectors.toMap(Ce1ExamineCircularSearchVo::getProductCode, Ce1ExamineCircularSearchVo::getSplitAmount, (v1, v2) -> v2));
            this.redisService.set(cacheKey, (Object)JSONObject.toJSONString(map), 43200L);
        }
        return list;
    }

    public BigDecimal getSalesIncludingTaxNetTotal(Ce1MnjtFullDto ce1MnjtFull) {
        return this.ce1MnjtService.getSalesIncludingTaxNetTotal(ce1MnjtFull);
    }

    public Integer getTotalNumber(List<String> codes, Integer codeType) {
        return this.ce1MnjtService.getTotalNumber(codes, codeType);
    }

    public Page<Ce1MnjtFullVo2> getMonthSummaryByFinancialYearAndFinancialMonth(Pageable pageable, String financialYear, String financialMonth) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.ce1MnjtMapper.getMonthSummaryByFinancialYearAndFinancialMonth((Page<Ce1MnjtFullVo2>)page, financialYear, financialMonth);
    }

    public Page<Ce1MnjtFullVo2> findSalesByConditions(Pageable pageable, Ce1MnjtFullDto dto) {
        return this.ce1MnjtService.findDaySalesByConditions(pageable, dto);
    }

    public List<Ce1MnjtFullVo2> findCustomerProductCe1MnjtSumList(Ce1MnjtSearchDto ce1MnjtSearchDto) {
        return this.ce1MnjtMapper.findCustomerProductCe1MnjtSumList(ce1MnjtSearchDto);
    }
}

