/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.third.system.local.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDimensionItemDto;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDto;
import com.biz.crm.mdm.business.price.sdk.enums.PriceDimensionEnum;
import com.biz.crm.mdm.business.price.sdk.enums.PriceTypeEnum;
import com.biz.crm.mdm.business.price.sdk.service.PriceModelVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.enums.SalesOrgLevelTypeEnum;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.mn.third.system.dataphin.sdk.vo.Ce1MnjtFullVo;
import com.biz.crm.tpm.business.third.system.local.entity.Ce1Mnjt;
import com.biz.crm.tpm.business.third.system.local.entity.Ce1MnjtCostDis;
import com.biz.crm.tpm.business.third.system.local.entity.Ce1MnjtInfo;
import com.biz.crm.tpm.business.third.system.local.mapper.Ce1MnjtCostDisMapper;
import com.biz.crm.tpm.business.third.system.local.mapper.Ce1MnjtInfoMapper;
import com.biz.crm.tpm.business.third.system.local.mapper.Ce1MnjtMapper;
import com.biz.crm.tpm.business.third.system.local.service.Ce1MnjtService;
import com.biz.crm.tpm.business.third.system.sdk.InvoiceTypeEnum;
import com.biz.crm.tpm.business.third.system.sdk.dto.Ce1ExamineCircularSearchDto;
import com.biz.crm.tpm.business.third.system.sdk.dto.Ce1MnjtFullDto;
import com.biz.crm.tpm.business.third.system.sdk.dto.Ce1MnjtSearchDto;
import com.biz.crm.tpm.business.third.system.sdk.vo.Ce1ExamineCircularSearchVo;
import com.biz.crm.tpm.business.third.system.sdk.vo.Ce1MnjtFullVo2;
import com.biz.crm.tpm.business.third.system.sdk.vo.Ce1MnjtFullVoExportsVo;
import com.biz.crm.tpm.business.third.system.sdk.vo.PlatformPriceVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class Ce1MnjtServiceImpl
extends ServiceImpl<Ce1MnjtMapper, Ce1Mnjt>
implements Ce1MnjtService {
    private static final Logger log = LoggerFactory.getLogger(Ce1MnjtServiceImpl.class);
    @Autowired(required=false)
    private Ce1MnjtMapper ce1MnjtMapper;
    @Autowired(required=false)
    private Ce1MnjtInfoMapper ce1MnjtInfoMapper;
    @Autowired(required=false)
    private Ce1MnjtCostDisMapper ce1MnjtCostDisMapper;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private PriceModelVoService priceModelVoService;

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void saveEntityBatch(List<Ce1MnjtFullVo> list, String ds) {
        list.forEach(vo -> {
            vo.setCId(UuidCrmUtil.general());
            String crmCustomerCode = vo.getCustomerCode() + vo.getSaleOrgCode() + vo.getDistributionChannelCode() + vo.getProductTeamCode();
            vo.setCrmCustomerCode(crmCustomerCode);
            vo.setVerifyCode(vo.getVerifyCodeOnly());
        });
        List verifyCodeList = list.stream().map(Ce1MnjtFullVo::getVerifyCodeOnly).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(verifyCodeList)) {
            List verifyCe1MnjtList = this.ce1MnjtMapper.selectList((Wrapper)Wrappers.lambdaQuery(Ce1Mnjt.class).in(Ce1Mnjt::getVerifyCode, verifyCodeList));
            this.ce1MnjtMapper.delete((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(Ce1Mnjt.class).in(Ce1Mnjt::getVerifyCode, verifyCodeList)).eq(Ce1Mnjt::getDs, (Object)ds));
            if (CollUtil.isNotEmpty((Collection)verifyCe1MnjtList)) {
                List cIds = verifyCe1MnjtList.stream().map(Ce1Mnjt::getCId).collect(Collectors.toList());
                this.ce1MnjtInfoMapper.delete((Wrapper)Wrappers.lambdaQuery(Ce1MnjtInfo.class).in(Ce1MnjtInfo::getTpmCe1MnjtId, cIds));
                this.ce1MnjtCostDisMapper.delete((Wrapper)Wrappers.lambdaQuery(Ce1MnjtCostDis.class).in(Ce1MnjtCostDis::getTpmCe1Id, cIds));
            }
        }
        this.ce1MnjtMapper.saveCe1MnjtEmtityBatch(list);
        this.ce1MnjtInfoMapper.saveCe1MnjtEmtityBatch(list);
        this.ce1MnjtCostDisMapper.saveCe1MnjtEmtityBatch(list);
    }

    @Override
    public Page<Ce1MnjtFullVo2> findDaySalesByConditions(Pageable pageable, Ce1MnjtFullDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new Ce1MnjtFullDto();
        }
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        if (StringUtils.isNotBlank((CharSequence)dto.getDocumentCreatDateStart())) {
            dto.setDocumentCreatDateStart(dto.getDocumentCreatDateStart().replace("-", ""));
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getDocumentCreatDateEnd())) {
            dto.setDocumentCreatDateEnd(dto.getDocumentCreatDateEnd().replace("-", ""));
        }
        LocalDate localDate = LocalDate.now();
        String postDateEnd = localDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        localDate = localDate.plusDays(-7L);
        String postDateStart = localDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        if (StringUtils.isNotBlank((CharSequence)dto.getPostDateStart())) {
            dto.setPostDateStart(dto.getPostDateStart().replace("-", ""));
        } else if (StringUtil.isEmpty((CharSequence)dto.getYearMonth())) {
            dto.setPostDateStart(postDateStart);
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getPostDateEnd())) {
            dto.setPostDateEnd(dto.getPostDateEnd().replace("-", ""));
        } else if (StringUtil.isEmpty((CharSequence)dto.getYearMonth())) {
            dto.setPostDateEnd(postDateEnd);
        }
        Page<Ce1MnjtFullVo2> ce1MnjtFullVoPage = this.ce1MnjtMapper.findDaySalesByConditions((Page<Ce1MnjtFullVo2>)page, dto);
        List records = ce1MnjtFullVoPage.getRecords();
        if (CollectionUtils.isNotEmpty((Collection)records)) {
            for (int i = 0; i < records.size(); ++i) {
                String cId = ((Ce1MnjtFullVo2)records.get(i)).getCId();
                String cIds = ((Ce1MnjtFullVo2)records.get(i)).getCids();
                if (!StringUtils.isNotBlank((CharSequence)cId)) continue;
                records.set(i, this.ce1MnjtMapper.findById(cId));
                ((Ce1MnjtFullVo2)records.get(i)).setCids(cIds);
            }
            List ids = records.stream().flatMap(o -> Arrays.stream(o.getCids().split(","))).collect(Collectors.toList());
            List ce1MnjtInfos = this.ce1MnjtInfoMapper.selectList((Wrapper)Wrappers.lambdaQuery(Ce1MnjtInfo.class).in(Ce1MnjtInfo::getTpmCe1MnjtId, ids));
            Map<String, Ce1MnjtInfo> ce1MnjtInfoMap = ce1MnjtInfos.stream().collect(Collectors.toMap(Ce1MnjtInfo::getTpmCe1MnjtId, Function.identity()));
            this.buildResult(records, ce1MnjtInfoMap, null);
        }
        return ce1MnjtFullVoPage;
    }

    @Override
    public Page<PlatformPriceVo> findPlatformPriceConditions(Pageable pageable, Ce1MnjtFullDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        String yearMonth = StringUtils.isBlank((CharSequence)dto.getYearMonth()) ? DateUtil.format((Date)new Date(), (String)"yyyyMM") : dto.getYearMonth().replace("-", "");
        dto.setYearMonth(yearMonth);
        log.info("\u5e73\u53f0\u4ef7\u683c\u8868\u67e5\u8be2\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)dto));
        List<PlatformPriceVo> records = this.ce1MnjtMapper.findDaySalesPriceByConditions(dto);
        if (CollectionUtils.isEmpty(records)) {
            return new Page();
        }
        HashSet customerCodeSet = new HashSet();
        HashSet productCodeSet = new HashSet();
        records.forEach(e -> {
            productCodeSet.add(e.getProductCode());
            String crmCustomerCode = e.getCustomerCode() + e.getSaleOrgCode() + e.getDistributionChannelCode() + e.getProductTeamCode();
            customerCodeSet.add(crmCustomerCode);
            e.setCrmCustomerCode(crmCustomerCode);
        });
        List productVos = this.productVoService.findByCodes(new ArrayList(productCodeSet));
        Map<String, String> productMap = productVos.stream().collect(Collectors.toMap(ProductVo::getProductCode, ProductVo::getProductName));
        List customerVoList = this.customerVoService.findBaseByCustomerCodes(new ArrayList(customerCodeSet));
        Map<String, String> estorePlatformMap = customerVoList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, e -> (String)StringUtils.defaultIfBlank((CharSequence)e.getEstorePlatform(), (CharSequence)"")));
        LinkedHashMap map = records.stream().collect(Collectors.groupingBy(PlatformPriceVo::getProductCode, LinkedHashMap::new, Collectors.groupingBy(PlatformPriceVo::getCrmCustomerCode)));
        SearchPriceDto searchPriceDto = new SearchPriceDto();
        searchPriceDto.setPriceTypeCode(PriceTypeEnum.STANDARD_RETAIL_PRICE.getDictCode());
        ArrayList<SearchPriceDimensionItemDto> itemDtos = new ArrayList<SearchPriceDimensionItemDto>();
        SearchPriceDimensionItemDto dimensionItemDto1 = new SearchPriceDimensionItemDto();
        dimensionItemDto1.setDimensionCode(PriceDimensionEnum.MATERIAL.getDictCode());
        dimensionItemDto1.setRelateCodeSet(map.keySet());
        itemDtos.add(dimensionItemDto1);
        searchPriceDto.setDimensionItems(itemDtos);
        Map standardRetailPrice = this.priceModelVoService.handleSearchPrice(searchPriceDto);
        log.info("\u6807\u51c6\u96f6\u552e\u4ef7\u67e5\u8be2\u7ed3\u679c,{}", (Object)JSON.toJSONString((Object)standardRetailPrice));
        ArrayList<PlatformPriceVo> resultList = new ArrayList<PlatformPriceVo>();
        for (String k : map.keySet()) {
            Map listMap = (Map)map.get(k);
            BigDecimal tmallChaoshiV = BigDecimal.ZERO;
            BigDecimal jdDeluxuV = BigDecimal.ZERO;
            BigDecimal distributionV = BigDecimal.ZERO;
            BigDecimal jdPopV = BigDecimal.ZERO;
            BigDecimal expandBusinessDepartmentV = BigDecimal.ZERO;
            BigDecimal tmallV = BigDecimal.ZERO;
            BigDecimal pddV = BigDecimal.ZERO;
            BigDecimal contentMarketingV = BigDecimal.ZERO;
            BigDecimal communityV = BigDecimal.ZERO;
            BigDecimal factoryV = BigDecimal.ZERO;
            BigDecimal jdMarketV = BigDecimal.ZERO;
            BigDecimal tmallChaoshiA = BigDecimal.ZERO;
            BigDecimal jdDeluxuA = BigDecimal.ZERO;
            BigDecimal distributionA = BigDecimal.ZERO;
            BigDecimal jdPopA = BigDecimal.ZERO;
            BigDecimal expandBusinessDepartmentA = BigDecimal.ZERO;
            BigDecimal tmallA = BigDecimal.ZERO;
            BigDecimal pddA = BigDecimal.ZERO;
            BigDecimal contentMarketingA = BigDecimal.ZERO;
            BigDecimal communityA = BigDecimal.ZERO;
            BigDecimal factoryA = BigDecimal.ZERO;
            BigDecimal jdMarketA = BigDecimal.ZERO;
            for (String k2 : listMap.keySet()) {
                String estorePlatformCode = estorePlatformMap.get(k2);
                if (StringUtils.isBlank((CharSequence)estorePlatformCode)) continue;
                BigDecimal salesVolumes = BigDecimal.ZERO;
                BigDecimal salesTaxAmount = BigDecimal.ZERO;
                List platformPriceVos = (List)listMap.get(k2);
                for (PlatformPriceVo vo : platformPriceVos) {
                    salesVolumes = salesVolumes.add(vo.getSalesVolumes());
                    salesTaxAmount = salesTaxAmount.add(vo.getSalesTaxAmount());
                }
                switch (estorePlatformCode) {
                    case "tmall": {
                        tmallChaoshiV = tmallChaoshiV.add(salesVolumes);
                        tmallChaoshiA = tmallChaoshiA.add(salesTaxAmount);
                        break;
                    }
                    case "jdtls": {
                        jdDeluxuV = jdDeluxuV.add(salesVolumes);
                        jdDeluxuA = jdDeluxuA.add(salesTaxAmount);
                        break;
                    }
                    case "onlinedistribution": {
                        distributionV = distributionV.add(salesVolumes);
                        distributionA = distributionA.add(salesTaxAmount);
                        break;
                    }
                    case "jdpopd": {
                        jdPopV = jdPopV.add(salesVolumes);
                        jdPopA = jdPopA.add(salesTaxAmount);
                        break;
                    }
                    case "tzywb": {
                        expandBusinessDepartmentV = expandBusinessDepartmentV.add(salesVolumes);
                        expandBusinessDepartmentA = expandBusinessDepartmentA.add(salesTaxAmount);
                        break;
                    }
                    case "tmall2": {
                        tmallV = tmallV.add(salesVolumes);
                        tmallA = tmallA.add(salesTaxAmount);
                        break;
                    }
                    case "pinduoduo": {
                        pddV = pddV.add(salesVolumes);
                        pddA = pddA.add(salesTaxAmount);
                        break;
                    }
                    case "nryx": {
                        contentMarketingV = contentMarketingV.add(salesVolumes);
                        contentMarketingA = contentMarketingA.add(salesTaxAmount);
                        break;
                    }
                    case "sqtg": {
                        communityV = communityV.add(salesVolumes);
                        communityA = communityA.add(salesTaxAmount);
                        break;
                    }
                    case "gczy": {
                        factoryV = factoryV.add(salesVolumes);
                        factoryA = factoryA.add(salesTaxAmount);
                        break;
                    }
                    case "jingdong": {
                        jdMarketV = jdMarketV.add(salesVolumes);
                        jdMarketA = jdMarketA.add(salesTaxAmount);
                        break;
                    }
                }
            }
            PlatformPriceVo resultVo = new PlatformPriceVo();
            resultVo.setProductCode(k);
            resultVo.setProductName(productMap.get(k));
            resultVo.setYearMonth(yearMonth);
            resultVo.setTmallChaoshi(BigDecimal.ZERO);
            resultVo.setJdDeluxu(BigDecimal.ZERO);
            resultVo.setDistribution(BigDecimal.ZERO);
            resultVo.setJdPop(BigDecimal.ZERO);
            resultVo.setExpandBusinessDepartment(BigDecimal.ZERO);
            resultVo.setTmall(BigDecimal.ZERO);
            resultVo.setPdd(BigDecimal.ZERO);
            resultVo.setContentMarketing(BigDecimal.ZERO);
            resultVo.setCommunity(BigDecimal.ZERO);
            resultVo.setFactory(BigDecimal.ZERO);
            resultVo.setJdMarket(BigDecimal.ZERO);
            resultVo.setStandardRetailPrice(standardRetailPrice.get(k) == null ? null : ((PriceModelVo)standardRetailPrice.get(k)).getPrice());
            if (BigDecimal.ZERO.compareTo(tmallChaoshiV) != 0 && BigDecimal.ZERO.compareTo(tmallChaoshiA) != 0) {
                resultVo.setTmallChaoshi(tmallChaoshiA.divide(tmallChaoshiV, 2, 4));
            }
            if (BigDecimal.ZERO.compareTo(jdDeluxuV) != 0 && BigDecimal.ZERO.compareTo(jdDeluxuA) != 0) {
                resultVo.setJdDeluxu(jdDeluxuA.divide(jdDeluxuV, 2, 4));
            }
            if (BigDecimal.ZERO.compareTo(distributionV) != 0 && BigDecimal.ZERO.compareTo(distributionA) != 0) {
                resultVo.setDistribution(distributionA.divide(distributionV, 2, 4));
            }
            if (BigDecimal.ZERO.compareTo(jdPopV) != 0 && BigDecimal.ZERO.compareTo(jdPopA) != 0) {
                resultVo.setJdPop(jdPopA.divide(jdPopV, 2, 4));
            }
            if (BigDecimal.ZERO.compareTo(expandBusinessDepartmentV) != 0 && BigDecimal.ZERO.compareTo(expandBusinessDepartmentA) != 0) {
                resultVo.setExpandBusinessDepartment(expandBusinessDepartmentA.divide(expandBusinessDepartmentV, 2, 4));
            }
            if (BigDecimal.ZERO.compareTo(tmallV) != 0 && BigDecimal.ZERO.compareTo(tmallA) != 0) {
                resultVo.setTmall(tmallA.divide(tmallV, 2, 4));
            }
            if (BigDecimal.ZERO.compareTo(pddV) != 0 && BigDecimal.ZERO.compareTo(pddA) != 0) {
                resultVo.setPdd(pddA.divide(pddV, 2, 4));
            }
            if (BigDecimal.ZERO.compareTo(contentMarketingV) != 0 && BigDecimal.ZERO.compareTo(contentMarketingA) != 0) {
                resultVo.setContentMarketing(contentMarketingA.divide(contentMarketingV, 2, 4));
            }
            if (BigDecimal.ZERO.compareTo(communityV) != 0 && BigDecimal.ZERO.compareTo(communityA) != 0) {
                resultVo.setCommunity(communityA.divide(communityV, 2, 4));
            }
            if (BigDecimal.ZERO.compareTo(factoryV) != 0 && BigDecimal.ZERO.compareTo(factoryA) != 0) {
                resultVo.setFactory(factoryA.divide(factoryV, 2, 4));
            }
            if (BigDecimal.ZERO.compareTo(jdMarketV) != 0 && BigDecimal.ZERO.compareTo(jdMarketA) != 0) {
                resultVo.setJdMarket(jdMarketA.divide(jdMarketV, 2, 4));
            }
            resultList.add(resultVo);
        }
        Page result = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        List subList = resultList.stream().skip((pageable.getPageNumber() - 1) * pageable.getPageSize()).limit(pageable.getPageSize()).collect(Collectors.toList());
        result.setRecords(subList);
        result.setTotal((long)resultList.size());
        result.setCurrent((long)pageable.getPageNumber());
        result.setPages(resultList.size() % pageable.getPageSize() == 0 ? (long)(resultList.size() / pageable.getPageSize()) : (long)(resultList.size() / pageable.getPageSize() + 1));
        return result;
    }

    @Override
    public List<Ce1MnjtFullVo2> findDataByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List ce1Mnjts = this.listByIds(ids);
        List ce1MnjtInfos = this.ce1MnjtInfoMapper.selectList((Wrapper)Wrappers.lambdaQuery(Ce1MnjtInfo.class).in(Ce1MnjtInfo::getTpmCe1MnjtId, ids));
        Map<Object, Object> ce1MnjtInfoMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)ce1MnjtInfos)) {
            ce1MnjtInfoMap = ce1MnjtInfos.stream().collect(Collectors.toMap(Ce1MnjtInfo::getTpmCe1MnjtId, Function.identity()));
        }
        if (CollectionUtils.isNotEmpty((Collection)ce1Mnjts)) {
            Collection ce1MnjtFullVo2s = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)ce1Mnjts, Ce1Mnjt.class, Ce1MnjtFullVo2.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            for (Ce1MnjtFullVo2 ce1MnjtFullVo2 : ce1MnjtFullVo2s) {
                Ce1MnjtInfo ce1MnjtInfo = (Ce1MnjtInfo)ce1MnjtInfoMap.get(ce1MnjtFullVo2.getCId());
                if (ce1MnjtInfo != null) {
                    ce1MnjtFullVo2.setSalesVolumes(ce1MnjtInfo.getSalesVolumes());
                    ce1MnjtFullVo2.setSalesIncludingTaxNet(ce1MnjtInfo.getSalesIncludingTaxNet());
                }
                ce1MnjtFullVo2.setTpmCustomerCode(ce1MnjtFullVo2.getCustomerCode() + ce1MnjtFullVo2.getSaleOrgCode() + ce1MnjtFullVo2.getDistributionChannelCode() + ce1MnjtFullVo2.getProductTeamCode());
            }
            return (List)ce1MnjtFullVo2s;
        }
        return Lists.newArrayList();
    }

    @Override
    public Page<Ce1MnjtFullVo2> findDataPage(Pageable pageable, String ds) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return ((Ce1MnjtMapper)this.baseMapper).findDataByPage((Page<Ce1MnjtFullVo2>)page, ds);
    }

    @Override
    public List<Ce1MnjtFullVo2> findCe1DataByCode(Page<Ce1MnjtFullVo2> page, List<String> codes, Integer codeType) {
        Page<Ce1MnjtFullVo2> ce1DataPage = this.ce1MnjtMapper.findCe1DataPage(page, codes, codeType);
        return ce1DataPage.getRecords();
    }

    @Override
    public Integer getTotalNumber(List<String> codes, Integer codeType) {
        Integer totalNumber = 0;
        switch (codeType) {
            case 1: {
                totalNumber = this.ce1MnjtMapper.selectCount((Wrapper)Wrappers.lambdaQuery(Ce1Mnjt.class).in(Ce1Mnjt::getMonthVerifyCode, codes));
                break;
            }
            case 2: {
                totalNumber = this.ce1MnjtMapper.selectCount((Wrapper)Wrappers.lambdaQuery(Ce1Mnjt.class).in(Ce1Mnjt::getDaySaleVerifyCode, codes));
                break;
            }
        }
        return totalNumber;
    }

    @Override
    public List<Ce1ExamineCircularSearchVo> findExamineCircularDataList(Ce1ExamineCircularSearchDto dto, String cacheKey) {
        if (StringUtils.isNotEmpty((CharSequence)dto.getStartDate()) && StringUtils.isNotEmpty((CharSequence)dto.getEndDate())) {
            Validate.isTrue((boolean)StringUtils.equals((CharSequence)dto.getStartDate().substring(0, 7), (CharSequence)dto.getEndDate().substring(0, 7)), (String)"\u67e5\u8be2\u65f6\u95f4\u4e0d\u80fd\u8de8\u6708\uff01", (Object[])new Object[0]);
        }
        if (StringUtils.isNotEmpty((CharSequence)(cacheKey = "TPM:EXAMINE_SALES_DATE_SPLIT:" + cacheKey))) {
            this.redisService.del(cacheKey);
        }
        if (StringUtils.isEmpty((CharSequence)dto.getSaleOrgCode()) || StringUtils.isEmpty((CharSequence)dto.getCustomerCode()) || StringUtils.isEmpty((CharSequence)dto.getStartDate()) || StringUtils.isEmpty((CharSequence)dto.getEndDate())) {
            return Lists.newArrayList();
        }
        List customerVos = this.customerVoService.findByCustomerCodes((List)com.google.common.collect.Lists.newArrayList((Object[])new String[]{dto.getCustomerCode()}));
        Validate.notEmpty((Collection)customerVos, (String)"\u5ba2\u6237\u7f16\u7801[%s]\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff01", (Object[])new Object[]{dto.getCustomerCode()});
        List salesOrgVos = this.salesOrgVoService.findAllParentBySalesOrgCode(dto.getSaleOrgCode());
        salesOrgVos = salesOrgVos.stream().filter(e -> StringUtils.equals((CharSequence)SalesOrgLevelTypeEnum.MECHANISM.getCode(), (CharSequence)e.getSalesOrgLevel())).collect(Collectors.toList());
        Validate.notEmpty(salesOrgVos, (String)"\u9500\u552e\u7ec4\u7ec7\u7f16\u7801[%s]\uff0c\u672a\u67e5\u8be2\u5230\u9500\u552e\u516c\u53f8\uff01", (Object[])new Object[]{dto.getSaleOrgCode()});
        String companyCode = ((SalesOrgVo)salesOrgVos.get(0)).getErpCode();
        dto.setSaleOrgCode(companyCode);
        dto.setCustomerCode(((CustomerVo)customerVos.get(0)).getErpCode());
        dto.setStartDate(dto.getStartDate().replaceAll("-", ""));
        dto.setEndDate(dto.getEndDate().replaceAll("-", ""));
        List<Ce1MnjtFullVo2> dataList = this.ce1MnjtMapper.findExamineCircularDataList(dto);
        ArrayList<Ce1ExamineCircularSearchVo> list = new ArrayList();
        if (CollectionUtils.isNotEmpty(dataList)) {
            List productCodeList = dataList.stream().map(Ce1MnjtFullVo2::getProductCode).distinct().collect(Collectors.toList());
            List productVoList = this.productVoService.findMainDetailsByProductCodes(productCodeList);
            Map<String, ProductVo> productMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, v -> v, (v1, v2) -> v2));
            List idList = dataList.stream().flatMap(o -> Arrays.stream(o.getCids().split(","))).collect(Collectors.toList());
            List ce1Infos = this.ce1MnjtInfoMapper.selectList((Wrapper)Wrappers.lambdaQuery(Ce1MnjtInfo.class).in(Ce1MnjtInfo::getTpmCe1MnjtId, idList));
            Map ce1InfoMap = ce1Infos.stream().collect(Collectors.toMap(Ce1MnjtInfo::getTpmCe1MnjtId, Function.identity()));
            BigDecimal salesIncludingTaxNet = BigDecimal.ZERO;
            for (Ce1MnjtFullVo2 v3 : dataList) {
                String[] idArr;
                for (String id : idArr = v3.getCids().split(",")) {
                    Ce1MnjtInfo ce1MnjtInfo = (Ce1MnjtInfo)ce1InfoMap.get(id);
                    if (ce1MnjtInfo == null || !Objects.nonNull(ce1MnjtInfo.getSalesIncludingTaxNet())) continue;
                    salesIncludingTaxNet = salesIncludingTaxNet.add(new BigDecimal(ce1MnjtInfo.getSalesIncludingTaxNet()));
                }
                Ce1ExamineCircularSearchVo searchVo = new Ce1ExamineCircularSearchVo();
                searchVo.setProductCode(v3.getProductCode());
                if (productMap.containsKey(v3.getProductCode())) {
                    ProductVo productVo = productMap.get(v3.getProductCode());
                    searchVo.setProductName(productVo.getProductName());
                    searchVo.setProductBrandCode(productVo.getProductBrandCode());
                    searchVo.setProductBrandName(productVo.getProductBrandName());
                    searchVo.setProductLevelCode(productVo.getProductCategoryCode());
                    searchVo.setProductLevelName(productVo.getProductCategoryName());
                    searchVo.setSubProductLevelCode(productVo.getProductLevelCode());
                    searchVo.setSubProductLevelName(productVo.getProductLevelName());
                }
                searchVo.setSplitAmount(salesIncludingTaxNet);
                searchVo.setProductCode(searchVo.getProductCode());
                list.add(searchVo);
            }
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(list = list.stream().filter(e -> Objects.nonNull(e.getSplitAmount()) && BigDecimal.ZERO.compareTo(e.getSplitAmount()) < 0).collect(Collectors.toList())) && StringUtils.isNotEmpty((CharSequence)cacheKey)) {
            Map<String, BigDecimal> map = list.stream().collect(Collectors.toMap(Ce1ExamineCircularSearchVo::getProductCode, Ce1ExamineCircularSearchVo::getSplitAmount, (v1, v2) -> v2));
            this.redisService.set(cacheKey, (Object)JSONObject.toJSONString(map), 43200L);
        }
        return list;
    }

    @Override
    public List<Ce1MnjtFullVo2> findDataByCustomerCodeAndDate(String customerCode, String productCode, List<String> dateList) {
        return this.ce1MnjtInfoMapper.findDataByCustomerAndDatas(customerCode, productCode, dateList);
    }

    @Override
    public List<Ce1MnjtFullVo2> findListByCondition(Ce1MnjtFullDto dto) {
        return this.ce1MnjtInfoMapper.findListByCondition(dto);
    }

    @Override
    public long findPageTotalByCondition(Ce1MnjtFullDto ce1MnjtFullDto) {
        if (Objects.isNull(ce1MnjtFullDto)) {
            return 0L;
        }
        return ((Ce1MnjtMapper)this.baseMapper).findPageTotalByCondition(ce1MnjtFullDto);
    }

    @Override
    public Page<Ce1MnjtFullVo2> findPageByCondition(Page<Ce1MnjtFullVo2> page, Ce1MnjtFullDto ce1MnjtFullDto) {
        if (Objects.isNull(ce1MnjtFullDto)) {
            return new Page();
        }
        return ((Ce1MnjtMapper)this.baseMapper).findPageByCondition(page, ce1MnjtFullDto);
    }

    @Override
    public List<Ce1MnjtFullVoExportsVo> findExportsByParams(Ce1MnjtFullDto ce1MnjtFull) {
        List<Ce1MnjtFullVoExportsVo> list = ((Ce1MnjtMapper)this.baseMapper).findExportsByParams(ce1MnjtFull);
        if (CollUtil.isEmpty(list)) {
            return Lists.newArrayList();
        }
        list.forEach(item -> {
            String invoicingTypeCode = item.getInvoicingTypeCode();
            if (CharSequenceUtil.isNotBlank((CharSequence)invoicingTypeCode)) {
                String invoicingTypeName = InvoiceTypeEnum.getNameByValue((String)invoicingTypeCode);
                item.setInvoicingTypeName(invoicingTypeName);
            }
        });
        return list;
    }

    @Override
    public BigDecimal getSalesIncludingTaxNetTotal(Ce1MnjtFullDto ce1MnjtFull) {
        return ((Ce1MnjtMapper)this.baseMapper).getSalesIncludingTaxNetTotal(ce1MnjtFull);
    }

    @Override
    public List<String> findCe1ByDs(String ds) {
        if (CharSequenceUtil.isEmpty((CharSequence)ds)) {
            return null;
        }
        return this.ce1MnjtMapper.findCe1IdByDs(ds);
    }

    @Override
    public void deleteCe1(String ds) {
        List<String> ce1ByDs = this.findCe1ByDs(ds);
        if (CollUtil.isEmpty(ce1ByDs)) {
            return;
        }
        ((Ce1MnjtMapper)this.baseMapper).delete((Wrapper)Wrappers.lambdaQuery(Ce1Mnjt.class).eq(Ce1Mnjt::getDs, (Object)ds));
        this.ce1MnjtInfoMapper.delete((Wrapper)Wrappers.lambdaQuery(Ce1MnjtInfo.class).in(Ce1MnjtInfo::getTpmCe1MnjtId, ce1ByDs));
        this.ce1MnjtCostDisMapper.delete((Wrapper)Wrappers.lambdaQuery(Ce1MnjtCostDis.class).in(Ce1MnjtCostDis::getTpmCe1Id, ce1ByDs));
    }

    @Override
    public Integer getCe1MnjtTotal(String ds) {
        Integer total = this.ce1MnjtMapper.selectCount((Wrapper)Wrappers.lambdaQuery(Ce1Mnjt.class).eq(Ce1Mnjt::getDs, (Object)ds));
        return ObjectUtil.isNull((Object)total) ? 0 : total;
    }

    private void buildResult(List<Ce1MnjtFullVo2> records, Map<String, Ce1MnjtInfo> ce1MnjtInfoMap, Map<String, Ce1MnjtCostDis> ce1MnjtCostDisMap) {
        for (Ce1MnjtFullVo2 record : records) {
            String[] ids = record.getCids().split(",");
            record.setSalesVolumes(BigDecimal.ZERO);
            record.setSalesIncludingTaxNet("0");
            record.setSalesTaxAmount("0");
            record.setStandardNumTon(BigDecimal.ZERO);
            record.setNetWeight(BigDecimal.ZERO);
            record.setGrossWeight(BigDecimal.ZERO);
            for (String id : ids) {
                Ce1MnjtInfo ce1MnjtInfo = ce1MnjtInfoMap.get(id);
                if (ce1MnjtInfo == null) continue;
                record.setCostCenter(ce1MnjtInfo.getCostCenter());
                record.setSenderCode(ce1MnjtInfo.getSenderCode());
                record.setSalesVolumes(record.getSalesVolumes().add(Optional.ofNullable(ce1MnjtInfo.getSalesVolumes()).orElse(BigDecimal.ZERO)));
                record.setSalesIncludingTaxNet(new BigDecimal(record.getSalesIncludingTaxNet()).add(Optional.of(new BigDecimal(ce1MnjtInfo.getSalesIncludingTaxNet())).orElse(BigDecimal.ZERO)).toPlainString());
                record.setSalesTaxAmount(new BigDecimal(record.getSalesTaxAmount()).add(Optional.of(new BigDecimal(ce1MnjtInfo.getSalesTaxAmount())).orElse(BigDecimal.ZERO)).toPlainString());
                record.setStandardNumTon(record.getStandardNumTon().add(Optional.ofNullable(ce1MnjtInfo.getStandardNumTon()).orElse(BigDecimal.ZERO)));
                record.setNetWeight(record.getNetWeight().add(Optional.ofNullable(ce1MnjtInfo.getNetWeight()).orElse(BigDecimal.ZERO)));
                record.setGrossWeight(record.getGrossWeight().add(Optional.ofNullable(ce1MnjtInfo.getGrossWeight()).orElse(BigDecimal.ZERO)));
            }
            if (!StringUtils.isNotEmpty((CharSequence)record.getInvoicingTypeCode())) continue;
            record.setInvoicingTypeName(InvoiceTypeEnum.getNameByValue((String)record.getInvoicingTypeCode()));
        }
    }

    @Override
    public List<Ce1MnjtFullVo2> findProductListByCustomerGroup(Ce1MnjtSearchDto dto) {
        List<Ce1MnjtFullVo2> ce1MnjtVos = this.ce1MnjtMapper.findProductListByCustomerGroup(dto);
        return ce1MnjtVos;
    }

    private void paramsAssignment(List<Ce1MnjtFullVo> itemValue, Ce1MnjtFullVo ce1MnjtFullVo) {
        BigDecimal salesVolumes = itemValue.stream().filter(item -> ObjectUtil.isNotNull((Object)item.getSalesVolumes()) && item.getSalesVolumes().compareTo(BigDecimal.ZERO) > 0).map(Ce1MnjtFullVo::getSalesVolumes).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal salesIncludingTaxNetDecimal = itemValue.stream().filter(item -> CharSequenceUtil.isNotEmpty((CharSequence)item.getSalesIncludingTaxNet())).map(Ce1MnjtFullVo::getSalesIncludingTaxNet).filter(Objects::nonNull).map(BigDecimal::new).reduce(BigDecimal.ZERO, BigDecimal::add);
        String salesIncludingTaxNet = String.valueOf(salesIncludingTaxNetDecimal);
        BigDecimal salesTaxAmountDecimal = itemValue.stream().filter(item -> CharSequenceUtil.isNotEmpty((CharSequence)item.getSalesTaxAmount())).map(Ce1MnjtFullVo::getSalesTaxAmount).map(BigDecimal::new).reduce(BigDecimal.ZERO, BigDecimal::add);
        String salesTaxAmount = String.valueOf(salesTaxAmountDecimal);
        BigDecimal standardNumTon = itemValue.stream().filter(item -> ObjectUtil.isNotNull((Object)item.getStandardNumTon()) && item.getStandardNumTon().compareTo(BigDecimal.ZERO) > 0).map(Ce1MnjtFullVo::getStandardNumTon).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal netWeight = itemValue.stream().filter(item -> ObjectUtil.isNotNull((Object)item.getNetWeight()) && item.getNetWeight().compareTo(BigDecimal.ZERO) > 0).map(Ce1MnjtFullVo::getNetWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal grossWeight = itemValue.stream().filter(item -> ObjectUtil.isNotNull((Object)item.getGrossWeight()) && item.getGrossWeight().compareTo(BigDecimal.ZERO) > 0).map(Ce1MnjtFullVo::getGrossWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
        ce1MnjtFullVo.setSalesVolumes(salesVolumes);
        ce1MnjtFullVo.setSalesIncludingTaxNet(salesIncludingTaxNet);
        ce1MnjtFullVo.setSalesTaxAmount(salesTaxAmount);
        ce1MnjtFullVo.setStandardNumTon(standardNumTon);
        ce1MnjtFullVo.setNetWeight(netWeight);
        ce1MnjtFullVo.setGrossWeight(grossWeight);
    }
}

