/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.third.system.local.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.mn.third.system.dataphin.sdk.service.DataPhinCe1MnjtService;
import com.biz.crm.tpm.business.third.system.local.service.Ce1MnLockService;
import com.biz.crm.tpm.business.third.system.local.service.Ce1MnjtService;
import com.biz.crm.tpm.business.third.system.local.service.PullCeSalesDataService;
import com.biz.crm.tpm.business.third.system.sdk.vo.Ce1MnLockVo;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import jodd.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class PullCeSalesDataServiceImpl
implements PullCeSalesDataService {
    private static final Logger log = LoggerFactory.getLogger(PullCeSalesDataServiceImpl.class);
    @Autowired
    private DataPhinCe1MnjtService dataPhinCe1MnjtService;
    @Autowired
    private Ce1MnjtService ce1MnjtService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private Ce1MnLockService ce1MnLockService;
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;
    private static final Integer SIZE = 400;

    @Override
    @Async
    public void pullSalesDataReportAsync(String ds, String createDate, AbstractCrmUserIdentity userIdentity) {
        this.loginUserService.refreshAuthentication((Object)userIdentity);
        Ce1MnLockVo vo = new Ce1MnLockVo();
        vo.setDs(ds);
        vo.setCurrentPageNumber(Integer.valueOf(0));
        this.pullSalesDataReport(vo);
    }

    @Override
    @Transactional(propagation=Propagation.NOT_SUPPORTED, rollbackFor={Exception.class})
    public void pullSalesDataReport(Ce1MnLockVo vo) {
        vo = Optional.ofNullable(vo).orElse(new Ce1MnLockVo());
        String ds = vo.getDs();
        Assert.hasLength((String)ds, (String)"ds\u65f6\u95f4[yyyyMMdd]\u4e0d\u80fd\u4e3a\u7a7a!");
        try {
            Date date = DateUtil.date_yyyyMMdd.parse(ds);
            Assert.isTrue((boolean)ds.equals(DateUtil.date_yyyyMMdd.format(date)), (String)"\u5e74\u6708\u683c\u5f0f\u9519\u8bef\u3010yyyyMMdd\u3011");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u5e74\u6708\u683c\u5f0f\u9519\u8bef\u3010yyyyMMdd\u3011");
        }
        String createDate = vo.getCeCreateDate();
        Integer pageNumber = Optional.ofNullable(vo.getCurrentPageNumber()).orElse(0);
        log.info("=====>    \u7535\u5546\u65e5\u9500\u552e\u62a5\u8868ds[{}], [{}]  start  <=====", (Object)ds, (Object)JSON.toJSONString((Object)vo));
        String lockKey = "pull:sales_data:lock:" + ds;
        boolean hasLock = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 6L);
        Assert.isTrue((boolean)hasLock, (String)("\u6b63\u5728\u62c9\u53d6[" + ds + "]\u6570\u636e\uff0c\u8bf7\u7a0d\u540e"));
        try {
            Integer total = this.dataPhinCe1MnjtService.getCe1MnjtDataTotal(ds, createDate);
            log.info("=====>    \u7535\u5546\u65e5\u9500\u552e\u62a5\u8868ds[{}],createDate[{}] total[{}]   <=====", new Object[]{ds, createDate, total});
            if (ObjectUtil.isNull((Object)total) || total.compareTo(0) == 0) {
                log.error("=====>    \u7535\u5546\u65e5\u9500\u552e\u62a5\u8868ds[{}],createDate[{}] total[{}]   <=====", new Object[]{ds, createDate, total});
                return;
            }
            vo.setTotal(total);
            vo.setRetryTime(Integer.valueOf(Optional.ofNullable(vo.getRetryTime()).orElse(0) + 1));
            int page = total / SIZE;
            page = total % SIZE == 0 ? page : page + 1;
            log.info("=====>    \u7535\u5546\u65e5\u9500\u552e\u62a5\u8868ds[{}],createDate[{}] total[{}] \u9700\u8c03\u7528[{}]\u6b21, \u6bcf\u6b21\u83b7\u53d6[{}]\u6761\u6570\u636e    <=====", new Object[]{ds, createDate, total, page, SIZE});
            for (int i = pageNumber.intValue(); i < page; ++i) {
                vo.setCurrentPageNumber(Integer.valueOf(i));
                List ce1MajDataList = this.dataPhinCe1MnjtService.getCe1MnjtData(ds, createDate, Integer.valueOf(i), SIZE);
                ce1MajDataList.forEach(item -> item.setProductCode(PullCeSalesDataServiceImpl.takeOutFrontZero(item.getProductCode())));
                this.ce1MnjtService.saveEntityBatch(ce1MajDataList, ds);
                log.info("=====>    \u7535\u5546\u65e5\u9500\u552e\u62a5\u8868\u7b2c[{}/{}]\u9875\u6570\u636e,\u6570\u636e\u603b\u6570[{}]\u6761\u4fdd\u5b58\u6210\u529f    <=====", new Object[]{i + 1, page, ce1MajDataList.size()});
            }
            this.sendMqMsg(ds);
        }
        catch (Exception e) {
            log.error("\u7535\u5546\u65e5\u9500\u552e\u62a5\u8868\u62c9\u53d6\u65f6\u62a5\u9519{}", (Object)e.getMessage());
            log.error("", (Throwable)e);
            try {
                this.ce1MnLockService.saveOrUpdateNewTransactional(vo);
            }
            catch (Exception lockE) {
                log.error("\u7535\u5546\u65e5\u9500\u552e\u62a5\u8868\u62c9\u53d6\u5f02\u5e38\u751f\u6210\u91cd\u590d\u8bf7\u6c42\u65f6\u62a5\u9519{}", (Object)e.getMessage());
                log.error("", (Throwable)lockE);
            }
            throw e;
        }
        finally {
            log.info("=====>    \u7535\u5546\u65e5\u9500\u552e\u62a5\u8868ds[{}], [{}]  end  <=====", (Object)ds, (Object)JSON.toJSONString((Object)vo));
            this.redisLockService.unlock(lockKey);
        }
    }

    private void sendMqMsg(String ds) {
        if (StringUtil.isEmpty((CharSequence)ds)) {
            return;
        }
        MqMessageVo msgCodeList = new MqMessageVo();
        msgCodeList.setMsgBody(ds);
        msgCodeList.setTag("SEND_PLATFORM_SALE_TAG");
        this.rocketMqProducer.sendMqOrderMsg(msgCodeList, ds, 10L);
        MqMessageVo mqMessageVo2 = new MqMessageVo();
        mqMessageVo2.setMsgBody(ds);
        mqMessageVo2.setTag("SEND_DISTRIBUTION_CUSTOMER_MONTH_SALE_TAG");
        this.rocketMqProducer.sendMqOrderMsg(mqMessageVo2, ds, 10L);
    }

    private static String takeOutFrontZero(String str) {
        int arrayLength = 0;
        char[] array = str.toCharArray();
        arrayLength = array.length;
        int firstNonZeroAt = 0;
        for (int i = 0; i < array.length; ++i) {
            if ("0".equalsIgnoreCase(String.valueOf(array[i]))) continue;
            firstNonZeroAt = i;
            break;
        }
        char[] newArray = Arrays.copyOfRange(array, firstNonZeroAt, arrayLength);
        return new String(newArray);
    }
}

