package com.biz.crm.tpm.business.third.system.sdk;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @Description: 发票类型
 * @Author: dengwei
 * @Date: 2023/2/14 11:06
 * @Version: 1.0
 */
@AllArgsConstructor
@Getter
public enum InvoiceTypeEnum {
//    F2-销售（正）         ，G2-贷项（负），          L2-借项（正），           RE-退货（负）
//    S1-冲销销售（负），ZS2-冲销贷项（正），ZS1-冲销借项（负），S2-冲销退货（正）
    F2("F2","销售（正）"),
    G2("G2","贷项（负）"),
    L2("L2","借项（正）"),
    RE("RE","退货（负）"),
    S1("S1","冲销销售（负）"),
    ZS2("ZS2","冲销贷项（正）"),
    ZS1("ZS1","冲销借项（负）"),
    S2("S2","冲销退货（正）")
    ;
    private String value;
    private String name;

    public static String getNameByValue(String value){
        for (InvoiceTypeEnum invoiceTypeEnum : InvoiceTypeEnum.values()) {
            if(invoiceTypeEnum.getValue().equals(value)){
                return invoiceTypeEnum.getName();
            }
        }
        return null;
    }
}
