package com.biz.crm.tpm.business.third.system.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import lombok.Data;

/**
 * 一盘货Dto
 *
 * @author liyang
 * @date 2024/04/09
 */
@Data
public class APalletGoodsDto extends TenantFlagOpDto {

  @ApiModelProperty("单据号")
  private String invoiceNo;

  @ApiModelProperty("行项目号")
  private String itemNo;

  @ApiModelProperty("业态")
  private	String businessFormatCode;

  @ApiModelProperty("调出方业务单元/区域")
  private	String outBusinessUnit;

  @ApiModelProperty("调入方业务单元/区域")
  private	String inBusinessUnit;

  @ApiModelProperty("产品编码")
  private	String productCode;

  @ApiModelProperty("产品名称")
  private	String productName;

  @ApiModelProperty("逻辑仓库")
  private	String logicWarehouse;

  @ApiModelProperty("数量")
  private	Integer quantity;

  @ApiModelProperty("出厂价")
  private BigDecimal factoryPrice;

  @ApiModelProperty("划拨日期")
  private String transferDate;

  @ApiModelProperty("建议点数")
  private BigDecimal suggestedPoints;

  @ApiModelProperty("浮动点数")
  private BigDecimal floatPoints;

  @ApiModelProperty("浮动原因")
  private String floatReason;

  @ApiModelProperty("调出方承担点数")
  private BigDecimal outPoints;

  @ApiModelProperty("第三方承担点数")
  private BigDecimal thirdPoints;

  @ApiModelProperty("费用金额（元）")
  private BigDecimal cost;
}
