package com.biz.crm.tpm.business.third.system.sdk.dto;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Entity;
import java.math.BigDecimal;
import java.util.List;

/**
 * Sap099获利能力分析数据表
 *
 * @author cyj
 */
@Getter
@Setter
public class TpmProfitabilityAnalysisDto extends TenantFlagOpVo {

  @ApiModelProperty("记录类型")
  private String recordType;
  @ApiModelProperty("公司代码")
  private String companyCode;
  @ApiModelProperty("利润中心代码")
  private String profitCenterCode;
  @ApiModelProperty("期间/年度")
  private String period;
  @ApiModelProperty("销售订单数")
  private BigDecimal orderNum;
  @ApiModelProperty("获利能力段编号")
  private String profitabilityCode;
  @ApiModelProperty("子编号")
  private String profitabilitySubcode;
  @ApiModelProperty("凭证编号")
  private String profitabilityVouCode;
  @ApiModelProperty("项目号")
  private String profitabilityItemno;
  @ApiModelProperty("工厂代码")
  private String factoryCode;
  @ApiModelProperty("分销渠道代码")
  private String channelCode;
  @ApiModelProperty("分销渠道名称")
  private String channelName;
  @ApiModelProperty("产品组代码")
  private String spartCode;
  @ApiModelProperty("货币类型代码")
  private String currencyTypeCode;
  @ApiModelProperty("开票类型")
  private String invoiceType;
  @ApiModelProperty("记帐日期")
  private String accountDate;
  private String accountDateBegin;
  private String accountDateEnd;
  @ApiModelProperty("售达方代码")
  private String dealerCode;
  @ApiModelProperty("售达方名称")
  private String dealerName;
  @ApiModelProperty("物料代码")
  private String materialCode;
  private List<String> materialCodes;
  private List<String> excludeMaterialCodes;
  @ApiModelProperty("物料描述")
  private String material;
  @ApiModelProperty("品牌代码")
  private String brandCode;
  private List<String> brandCodes;
  private List<String> excludeBrandCodes;
  @ApiModelProperty("品牌描述")
  private String brand;
  @ApiModelProperty("品类代码")
  private String categoryCode;
  private List<String> categoryCodes;
  private List<String> excludeCategoryCodes;
  @ApiModelProperty("品类")
  private String categoryName;
  @ApiModelProperty("品项代码")
  private String itemCode;
  private List<String> itemCodes;
  private List<String> excludeItemCodes;
  @ApiModelProperty("品项")
  private String itemName;
  @ApiModelProperty("上市分类代码")
  private String listClassifyCode;
  @ApiModelProperty("送达方代码")
  private String serviceCode;
  private List<String> includeServiceCodes;
  @ApiModelProperty("送达方名称")
  private String serviceName;
  @ApiModelProperty("销售人员代码")
  private String salesmanCode;
  @ApiModelProperty("销售地区代码")
  private String salesAreaCode;
  @ApiModelProperty("成本要素")
  private String costElement;
  @ApiModelProperty("成本中心代码")
  private String costCenterCode;
  @ApiModelProperty("税率")
  private BigDecimal taxRate;
  @ApiModelProperty("标准供价")
  private String standardSupplyPrice;
  @ApiModelProperty("标准成本价")
  private String standardCostPrice;
  @ApiModelProperty("库存单位销售数量")
  private BigDecimal salesNum;
  @ApiModelProperty("标准收入（含税）")
  private BigDecimal standardIncomeIntax;
  @ApiModelProperty("标准收入（未税）")
  private BigDecimal standardIncomeNotax;
  @ApiModelProperty("实际收入（含税）")
  private BigDecimal actualIncomeIntax;
  @ApiModelProperty("退货差价")
  private String returnPriceDiff;
  @ApiModelProperty("实际收入（未税）")
  private BigDecimal actualIncomeNotax;
  @ApiModelProperty("随车折扣")
  private BigDecimal onboardDiscount;
  @ApiModelProperty("随单费用")
  private BigDecimal inOrderExpenses;
  @ApiModelProperty("月末折扣")
  private BigDecimal monthEndDiscount;
  @ApiModelProperty("标准成本（含税）")
  private BigDecimal standardCostIntax;
  @ApiModelProperty("标准成本（未税）")
  private BigDecimal standardCostNotax;
  @ApiModelProperty("实际成本（含税）")
  private BigDecimal actualCostIntax;
  @ApiModelProperty("实际成本（未税）")
  private String actualCostNotax;
  @ApiModelProperty("理论毛利(未税)")
  private BigDecimal theoryGrossProfitNotax;
  @ApiModelProperty("理论毛利率(未税)")
  private String theoryGrossProfitRatioNotax;
  @ApiModelProperty("实际毛利(未税)")
  private BigDecimal actualGrossProfitNotax;
  @ApiModelProperty("实际毛利率(未税)")
  private String actualGrossProfitRatioNotax;
  @ApiModelProperty("理论毛利")
  private BigDecimal theoryGrossProfit;
  @ApiModelProperty("理论毛利率")
  private String theoryGrossProfitRatio;
  @ApiModelProperty("实际毛利")
  private BigDecimal actualGrossProfit;
  @ApiModelProperty("实际毛利率")
  private String actualGrossProfitRatio;
  @ApiModelProperty("费用ZK50(含ZK00)")
  private String costZk50;
  @ApiModelProperty("搭赠ZK00")
  private String giftZk00;
  @ApiModelProperty("从条件定价过程小计")
  private String conditionPriceSubtotal;
  @ApiModelProperty("分析类型代码")
  private String analyseTypeCode;
  @ApiModelProperty("分析类型描述")
  private String analyseType;
  @ApiModelProperty("净重")
  private BigDecimal netWeight;
  @ApiModelProperty("毛重")
  private String grossWeight;
  @ApiModelProperty("项目类别")
  private String saleVouItemType;
  @ApiModelProperty("记录日期")
  private String recordDate;
  @ApiModelProperty("时戳")
  private String stampTime;
  @ApiModelProperty("时间分区")
  private String ds;

  @ApiModelProperty(value = "组织编码", notes = "")
  private String orgCode;

  @ApiModelProperty(value = "组织名称", notes = "")
  private String orgName;

  @ApiModelProperty("客户编码")
  private String customerCode;

  @ApiModelProperty("所属销售机构编码")
  private String salesInstitutionCode;

  @ApiModelProperty("所属销售机构编码")
  private String salesInstitutionErpCode;

  @ApiModelProperty("所属销售机构")
  private String salesInstitutionName;

  @ApiModelProperty(value = "salesRegionCode", name = "销售部门编码", notes = "销售部门编码")
  private String salesRegionCode;

  @ApiModelProperty(value = "salesRegionName", name = "销售部门名称", notes = "销售部门名称")
  private String salesRegionName;

  @ApiModelProperty(value = "salesRegionErpCode", name = "销售部门erp编码", notes = "销售部门erp编码")
  private String salesRegionErpCode;

  @ApiModelProperty(name = "销售组织编码", notes = "销售组织编码")
  private String salesOrgCode;

  @ApiModelProperty(name = "销售组织名称", notes = "销售组织名称")
  private String salesOrgName;

  @ApiModelProperty("销售组织erp编码")
  private String salesOrgErpCode;
}
