package com.biz.crm.tpm.business.third.system.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.third.system.sdk.dto.Ce1ExamineCircularSearchDto;
import com.biz.crm.tpm.business.third.system.sdk.dto.Ce1MnjtFullDto;
import com.biz.crm.tpm.business.third.system.sdk.dto.Ce1MnjtSearchDto;
import com.biz.crm.tpm.business.third.system.sdk.vo.Ce1ExamineCircularSearchVo;
import com.biz.crm.tpm.business.third.system.sdk.vo.Ce1MnjtFullVo2;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;
import java.util.List;

/**
 * @Description: 电商日销售数据
 * @Author: dengwei
 * @Date: 2023/2/14 20:07
 * @Version: 1.0
 */
public interface Ce1MnjtSdkService {

    /**
     * 根据id查询数据
     * @param ids
     * @return
     */
    List<Ce1MnjtFullVo2> findDataByIds(List<String> ids);

    List<Ce1MnjtFullVo2> findCe1DataByCodes(Page<Ce1MnjtFullVo2> page, List<String> code, Integer codeType);

    Page<Ce1MnjtFullVo2> findDataPage(Pageable pageable, String ds);

    Integer getCeqMnjtTotal(String ds);

    /**
     * 根据条件查询
     * @param customerCode 客户
     * @param datas 时间
     * @return List
     */
    List<Ce1MnjtFullVo2> findDataByCustomerCodeAndDatas(String customerCode, String productCode, List<String> datas);

    /**
     * 根据条件查询
     * @param dto
     * @return
     */
    List<Ce1MnjtFullVo2> findListByCondition(Ce1MnjtFullDto dto);

    long findPageTotalByCondition(Ce1MnjtFullDto ce1MnjtFullDto);

    Page<Ce1MnjtFullVo2> findPageByCondition(Page<Ce1MnjtFullVo2> page, Ce1MnjtFullDto ce1MnjtFullDto);

    /**
     * 考勤通报管理查询分摊数据
     *
     * @param dto
     * @return
     */
    List<Ce1ExamineCircularSearchVo> findExamineCircularDataList(Ce1ExamineCircularSearchDto dto, String cacheKey);



    BigDecimal getSalesIncludingTaxNetTotal(Ce1MnjtFullDto ce1MnjtFull);

    Integer getTotalNumber(List<String> codes, Integer codeType);

    Page<Ce1MnjtFullVo2> getMonthSummaryByFinancialYearAndFinancialMonth(Pageable pageable, String financialYear, String financialMonth);

    Page<Ce1MnjtFullVo2> findSalesByConditions(Pageable pageable, Ce1MnjtFullDto dto);

    /**
     * 根据客户+产品汇总
     */
    List<Ce1MnjtFullVo2> findCustomerProductCe1MnjtSumList(Ce1MnjtSearchDto ce1MnjtSearchDto);

}
