package com.biz.crm.tpm.business.third.system.sdk.service;

import com.biz.crm.mn.third.system.sap.fi.sdk.dto.AccountingVoucherDto;
import com.biz.crm.mn.third.system.sap.fi.sdk.dto.ChargeAgainstAccountingVoucherDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.SapRedInvoiceSaleOrderCreateDto;
import com.biz.crm.mn.third.system.sap.fi.sdk.vo.ChargeAgainstAccountingVoucherVo;
import com.biz.crm.mn.third.system.sap.fi.sdk.vo.SapAccountingVoucherVo;
import com.biz.crm.mn.third.system.sd.sdk.dto.AuditFeeUpAccountDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.AuditFeeUpAccountSonCompanyDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.FeePoolQueryDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.FeePoolQuerySonCompanyDto;
import com.biz.crm.mn.third.system.sd.sdk.vo.FeePoolQuerySonCompanyVo;
import com.biz.crm.mn.third.system.sd.sdk.vo.FeePoolQueryVo;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/29 17:55
 * @description：SAP接口服务
 */
public interface SAPCenterService {

    /**
     * sap上账接口
     * @param dto
     * @return
     */
    SapAccountingVoucherVo pushSapAccountingVoucher(AccountingVoucherDto dto);

    /**
     * sap冲销接口
     * @param dto
     * @return
     */
    ChargeAgainstAccountingVoucherVo pushSapChargeAgainstAccountingVoucher(ChargeAgainstAccountingVoucherDto dto);

    /**
     * 核销费用上账接口
     * @param dto
     */
    void auditFeeUpAccount(AuditFeeUpAccountDto dto);

    /**
     * 核销费用上账接口-分子公司
     * @param dto
     */
    void auditFeeUpAccountSonCompany(AuditFeeUpAccountSonCompanyDto dto);

    /**
     * 费用池查询-总部
     * @param dto
     * @return
     */
    FeePoolQueryVo feePoolQuery(FeePoolQueryDto dto);

    /**
     * 费用池查询-分子公司
     * @param dto
     * @return
     */
    FeePoolQuerySonCompanyVo feePoolQuerySonCompany(FeePoolQuerySonCompanyDto dto);

    /**
     * sap销售订单创建接口
     * @param dto 参数
     * @return SapRedInvoiceSaleOrderCreateVo
     */
    void pushSapSaleOrderCreate(SapRedInvoiceSaleOrderCreateDto dto);
}
