package com.biz.crm.tpm.business.third.system.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.third.system.sdk.dto.TpmProfitabilityAnalysisDto;
import com.biz.crm.tpm.business.third.system.sdk.dto.TpmZtfi099ForEctQueryDto;
import com.biz.crm.tpm.business.third.system.sdk.vo.TpmProfitabilityAnalysisVo;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;
import java.util.List;

/**
 * Sap099获利能力分析数据表(TpmProfitabilityAnalysis)表服务接口
 *
 * @author huanglong
 * @date 2023-01-13 12:01:40
 */
public interface TpmProfitabilityAnalysisService {


    /**
     * 根据年月执行099同步
     *
     * @param yearMonth   年月  yyyyMM
     * @param companyCode 公司代码
     * @param accountDate 过账日期
     * @return void
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2024/3/29 11:12
     */
    void pull099ByYearMonth(String yearMonth, String companyCode, String accountDate);

    /**
     * 根据年月执行099同步
     *
     * @param yearMonth    年月  yyyyMM
     * @param companyCode  公司代码
     * @param accountDate  过账日期
     * @return void
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2024/3/29 11:12
     */
    void handPull099ByYearMonthAsync(String yearMonth, String companyCode, String accountDate);

    List<TpmProfitabilityAnalysisVo> listForVariable(TpmProfitabilityAnalysisDto dto);

    /**
     * 查询tpm数据库中的099数据
     *
     * @param pageable
     * @param ectZtfi099QueryDto
     * @return
     */
    Page<TpmProfitabilityAnalysisVo> findData4Ect(Pageable pageable, TpmZtfi099ForEctQueryDto ectZtfi099QueryDto);

    /**
     * 查询099报表 实际理论毛利=实际收入（含税）-实际成本（含税） 条件；发货过账日期+公司代码
     *
     * @param analysisDtos
     * @return
     */
    List<TpmProfitabilityAnalysisVo> findDataSummaryByProfitMonitor(List<TpmProfitabilityAnalysisDto> analysisDtos);

    BigDecimal computeAmountForProductMergeSaleAmount(TpmProfitabilityAnalysisDto dto3);
}
