package com.biz.crm.tpm.business.third.system.sdk.vo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author yangshen
 * @version 1.0
 * @date 2023/1/12 14:02
 * @ClassName Ce1MnjtVoSum
 * @Description TODO
 */
@Data
public class Ce1MnjtFullVo2 {

    /**
     * 冗余字段
     */
    private String cId;

    private String cids;

    /**
     * SAP客户端
     */
    @ApiModelProperty("SAP客户端")
    private String mandt;

    /**
     * 经营范围的货币类型
     */
    @ApiModelProperty("经营范围的货币类型")
    private String businessScopeCurrencyType;

    /**
     * 记录类型
     */
    @ApiModelProperty("记录类型")
    private String recordType;

    /**
     * 计划版本(CO-PA)
     */
    @ApiModelProperty("计划版本(CO-PA)")
    private String planEditionCoPa;

    /**
     * 期间/年度
     */
    @ApiModelProperty("期间/年度")
    private String periodYear;

    /**
     * 获利能力段编号(CO-PA)
     */
    @ApiModelProperty("获利能力段编号(CO-PA)")
    private String profitabilitySegmentNumberCopa;

    /**
     * 获利能力的段修改(CO-PA)
     */
    @ApiModelProperty("获利能力的段修改(CO-PA)")
    private String profitSegmentModifyCoPa;

    /**
     * 获利分段行项目的凭证号
     */
    @ApiModelProperty("获利分段行项目的凭证号")
    private String profitSegmentLineItemVoucherNum;

    /**
     * CO-PA行项目的项目号
     */
    @ApiModelProperty("CO-PA行项目的项目号")
    private String coPaLineItemItemNum;

    /**
     * 记录的创建日期
     */
    @ApiModelProperty("记录的创建日期")
    private String documentCreatDate;

    /**
     * 创建人
     */
    @ApiModelProperty("创建人")
    private String creator;

    /**
     * 财年
     */
    @ApiModelProperty("财年")
    private String fiscalYear;

    /**
     * 期间
     */
    @ApiModelProperty("期间")
    private String period;

    /**
     * 发货日期
     */
    @ApiModelProperty("发货日期")
    private String deliveryDate;

    /**
     * 发票日期(创建日期)
     */
    @ApiModelProperty("发票日期(创建日期)")
    private String invoiceDateCreateDate;

    /**
     * 过帐日期
     */
    @ApiModelProperty("过帐日期")
    private String postDate;

    /**
     * 期间/年在可选的期间类型
     */
    @ApiModelProperty("期间/年在可选的期间类型")
    private String periodYearOptionalPeriodType;

    /**
     * 伙伴获利能力的段号(CO-PA)
     */
    @ApiModelProperty("伙伴获利能力的段号(CO-PA)")
    private String partnerProfitSegmentNumCoPa;

    /**
     * 修改伙伴获利能力段(CO-PA)
     */
    @ApiModelProperty("修改伙伴获利能力段(CO-PA)")
    private String modifyPartnerProfitSegmentCoPa;

    /**
     * 客户代码
     */
    @ApiModelProperty("客户代码")
    private String customerCode;

    private String tpmCustomerCode;

    /**
     * 产品代码
     */
    @ApiModelProperty("产品代码")
    private String productCode;

    /**
     * 开票类型代码
     */
    @ApiModelProperty("开票类型代码")
    private String invoicingTypeCode;

    @ApiModelProperty("开票类型描述")
    private String invoicingTypeName;

    /**
     * 外币码
     */
    @ApiModelProperty("外币码")
    private String foreignCurrencyCode;

    /**
     * 汇率
     */
    @ApiModelProperty("汇率")
    private String exchangeRate;

    /**
     * 汇率对于经营范围货币->公司代码货币
     */
    @ApiModelProperty("汇率对于经营范围货币->公司代码货币")
    private String exchangeRateBusinessScopeCurrencyCompanyCodeCurrency;

    /**
     * 汇率经营范围货币->货币组
     */
    @ApiModelProperty("汇率经营范围货币->货币组")
    private String exchangeRateBusinessScopeCurrencyCurrencyGroup;

    /**
     * 数据记录货币
     */
    @ApiModelProperty("数据记录货币")
    private String dataRecordCurrency;

    /**
     * 销售订单数
     */
    @ApiModelProperty("销售订单数")
    private String salesOrdersNum;

    /**
     * 销售订单中的项目编号
     */
    @ApiModelProperty("销售订单中的项目编号")
    private String salesOrderItemNum;

    /**
     * 订单号
     */
    @ApiModelProperty("订单号")
    private String orderCode;

    /**
     * 发送方成本中心
     */
    @ApiModelProperty("发送方成本中心")
    private String senderCostCenter;

    /**
     * 发送方业务处理
     */
    @ApiModelProperty("发送方业务处理")
    private String senderBusinessProcessing;

    /**
     * 公司代码
     */
    @ApiModelProperty("公司代码")
    private String companyCode;

    /**
     * 控制范围
     */
    @ApiModelProperty("控制范围")
    private String controlScope;

    /**
     * 工厂代码
     */
    @ApiModelProperty("工厂代码")
    private String factoryCode;

    /**
     * 业务范围
     */
    @ApiModelProperty("业务范围")
    private String businessScope;

    /**
     * 销售组织代码
     */
    @ApiModelProperty("销售组织代码")
    private String saleOrgCode;

    /**
     * 分销渠道代码
     */
    @ApiModelProperty("分销渠道代码")
    private String distributionChannelCode;

    /**
     * 产品组代码
     */
    @ApiModelProperty("产品组代码")
    private String productTeamCode;

    /**
     * 来源(CO-PA)
     */
    @ApiModelProperty("来源(CO-PA)")
    private String sourceCoPa;

    /**
     * 计划/实际标识
     */
    @ApiModelProperty("计划/实际标识")
    private String planActualFlag;

    /**
     * 成本要素代码
     */
    @ApiModelProperty("成本要素代码")
    private String costElementCode;

    /**
     * 工作分解结构元素(WBS元素)
     */
    @ApiModelProperty("工作分解结构元素(WBS元素)")
    private String workBreakdownStructureElement;

    /**
     * 成本对象
     */
    @ApiModelProperty("成本对象")
    private String costObject;

    /**
     * 参考凭证号对于CO-PA行项目
     */
    @ApiModelProperty(" 参考凭证号对于CO-PA行项目")
    private String referenceDocumentNumCoPaLineItem;

    /**
     * 从参考文本的项目号(CO-PA)
     */
    @ApiModelProperty("从参考文本的项目号(CO-PA)")
    private String itemNumFromReferenceTextCoPa;

    /**
     * 已取消凭证
     */
    @ApiModelProperty("已取消凭证")
    private String canceledVoucher;

    /**
     * 已取消凭证项目
     */
    @ApiModelProperty("已取消凭证项目")
    private String canceledVoucherItem;

    /**
     * 利润中心代码
     */
    @ApiModelProperty("利润中心代码")
    private String profitCenterCode;

    /**
     * 伙伴利润中心
     */
    @ApiModelProperty("伙伴利润中心")
    private String partnerProfitCenter;

    /**
     * 更新状态对于CO-PA行项目
     */
    @ApiModelProperty("更新状态对于CO-PA行项目")
    private String updateStatusCoPaLineItems;

    /**
     * 创建的时间(格林威治时间)
     */
    @ApiModelProperty("创建的时间(格林威治时间)")
    private String timeCreateGreenwichMeanTime;

    /**
     * 参考交易
     */
    @ApiModelProperty("参考交易")
    private String referenceTransaction;

    /**
     * 参考组织单位
     */
    @ApiModelProperty("参考组织单位")
    private String referenceOrgUnit;

    /**
     * CO-PA估价点
     */
    @ApiModelProperty("CO-PA估价点")
    private String coPaValuationPoint;

    /**
     * 源凭证的逻辑系统
     */
    @ApiModelProperty("源凭证的逻辑系统")
    private String sourceVoucherLogicalSystem;

    /**
     * 客户组代码
     */
    @ApiModelProperty("客户组代码")
    private String customerGroupCode;

    /**
     * 物料组代码
     */
    @ApiModelProperty("物料组代码")
    private String materialGroupCode;

    /**
     * 产品层次代码
     */
    @ApiModelProperty("product_level_code")
    private String productLevelCode;

    /**
     * CO-PA合作伙伴
     */
    @ApiModelProperty("CO-PA合作伙伴")
    private String coPaPartner;

    /**
     * 销售办公室代码
     */
    @ApiModelProperty("销售办公室代码")
    private String saleOfficeCode;

    /**
     * 品牌代码
     */
    @ApiModelProperty("品牌代码")
    private String brand;

    /**
     * 成本中心
     */
    @ApiModelProperty("成本中心")
    private String costCenter;

    /**
     * 销售组代码
     */
    @ApiModelProperty("销售组代码")
    private String saleGroupCode;

    /**
     * 送达方代码
     */
    @ApiModelProperty("送达方代码")
    private String senderCode;

    /**
     * 销售人员
     */
    @ApiModelProperty("销售人员")
    private String salesman;

    /**
     * 销售地区代码
     */
    @ApiModelProperty("销售地区代码")
    private String saleAreaCode;

    /**
     * 国家代码
     */
    @ApiModelProperty("国家代码")
    private String countryCode;

    /**
     * 基本计量单位
     */
    @ApiModelProperty("基本计量单位")
    private String measureBaseUnit;

    /**
     * 基本计量单位2
     */
    @ApiModelProperty("基本计量单位2")
    private String basicUom2;

    /**
     * 基本计量单位3
     */
    @ApiModelProperty("基本计量单位3")
    private String basicUom3;

    /**
     * 基本计量单位4
     */
    @ApiModelProperty("基本计量单位4")
    private String basicUom4;

    /**
     * 基本计量单位5
     */
    @ApiModelProperty("基本计量单位5")
    private String basicUom5;

    /**
     * 基本计量单位6
     */
    @ApiModelProperty("基本计量单位6")
    private String basicUom6;

    /**
     * 销售数量
     */
    @ApiModelProperty("销售数量")
    private BigDecimal salesVolumes;

    /**
     * 固定生产成本
     */
    @ApiModelProperty("固定生产成本")
    private String fixedProductionCost;

    /**
     * 比例生产成本
     */
    @ApiModelProperty("比例生产成本")
    private String proportionalProductionCost;

    /**
     * 总销售额
     */
    @ApiModelProperty("总销售额")
    private String salesTot;

    /**
     * 批大小差异
     */
    @ApiModelProperty("批大小差异")
    private String batchSizeDifference;

    /**
     * 闲置生产能力成本
     */
    @ApiModelProperty("闲置生产能力成本")
    private String idleProductionCapacityCost;

    /**
     * 数量差异
     */
    @ApiModelProperty("数量差异")
    private String numVariance;

    /**
     * 价格差异
     */
    @ApiModelProperty("价格差异")
    private String priceVariance;

    /**
     * 资源利用差异
     */
    @ApiModelProperty("资源利用差异")
    private String resourceUtilizationVariance;

    /**
     * 其它偏差
     */
    @ApiModelProperty("其它偏差")
    private String otherDeviations;

    /**
     * 主营业务收入
     */
    @ApiModelProperty("主营业务收入")
    private String mainBusinessIncome;

    /**
     * 其他业务收入
     */
    @ApiModelProperty("其他业务收入")
    private String otherBusinessIncome;

    /**
     * 公允价值变动损益
     */
    @ApiModelProperty("公允价值变动损益")
    private String fairValueChangesProfitLoss;

    /**
     * 投资收益
     */
    @ApiModelProperty("投资收益")
    private String incomeFromInvestment;

    /**
     * 营业外收入
     */
    @ApiModelProperty("营业外收入")
    private String nonbusinessIncome;

    /**
     * 主营业务成本
     */
    @ApiModelProperty("主营业务成本")
    private String mainBusinessCost;

    /**
     * 其他业务支出
     */
    @ApiModelProperty("其他业务支出")
    private String otherBusinessExpenses;

    /**
     * 营业税金及附加
     */
    @ApiModelProperty("营业税金及附加")
    private String businessTaxesAndSurcharges;

    /**
     * 部门间接费用
     */
    @ApiModelProperty("部门间接费用")
    private String departmentOverhead;

    /**
     * 财务费用
     */
    @ApiModelProperty("财务费用")
    private String financialExpenses;

    /**
     * 资产减值损失
     */
    @ApiModelProperty("资产减值损失")
    private String assetsImpairmentLoss;

    /**
     * 营业外支出
     */
    @ApiModelProperty("营业外支出")
    private String nonbusinessExpenses;

    /**
     * 所得税费用
     */
    @ApiModelProperty("所得税费用")
    private String incomeTaxExpense;

    /**
     * 以前年度损益调整
     */
    @ApiModelProperty("以前年度损益调整")
    private String priorYearIncomeAdjustment;

    /**
     * 折前金额
     */
    @ApiModelProperty("折前金额")
    private String amountBeforeDiscount;

    /**
     * 含税销售额(净额)
     */
    @ApiModelProperty("含税销售额(净额)")
    private String salesIncludingTaxNet;

    /**
     * 采购成本
     */
    @ApiModelProperty("采购成本")
    private String purchaseCost;

    /**
     * 进项税
     */
    @ApiModelProperty("进项税")
    private String inputTax;

    /**
     * 委外材料成本
     */
    @ApiModelProperty("委外材料成本")
    private String outsourcingMaterialCost;

    /**
     * 委外加工费
     */
    @ApiModelProperty("委外加工费")
    private String outsourcingFee;

    /**
     * 委外收货结转
     */
    @ApiModelProperty("委外收货结转")
    private String subcontractingReceiptCarryForward;

    /**
     * 销售含税金额
     */
    @ApiModelProperty("销售含税金额")
    private String salesTaxAmount;

    /**
     * 金额备用01
     */
    @ApiModelProperty("金额备用01")
    private String amountReserve01;

    /**
     * 金额备用02
     */
    @ApiModelProperty("金额备用02")
    private String amountReserve02;

    /**
     * 金额备用03
     */
    @ApiModelProperty("金额备用03")
    private String amountReserve03;

    /**
     * 金额备用04
     */
    @ApiModelProperty("金额备用04")
    private String amountReserve04;

    /**
     * 金额备用05
     */
    @ApiModelProperty("金额备用05")
    private String amountReserve05;

    /**
     * 金额备用06
     */
    @ApiModelProperty("金额备用06")
    private String amountReserve06;

    /**
     * 标准数量(吨)
     */
    @ApiModelProperty("标准数量(吨)")
    private BigDecimal standardNumTon;

    /**
     * 净重量
     */
    @ApiModelProperty("净重量")
    private BigDecimal netWeight;

    /**
     * 毛重
     */
    @ApiModelProperty("毛重")
    private BigDecimal grossWeight;

    /**
     * 业务量
     */
    @ApiModelProperty("业务量")
    private BigDecimal businessNum;

    /**
     * 产品成本构成_原奶成本
     */
    @ApiModelProperty("产品成本构成_原奶成本")
    private String pccRawMilkCost;

    /**
     * 产品成本构成_白糖成本
     */
    @ApiModelProperty("产品成本构成_白糖成本")
    private String pccSugarCost;

    /**
     * 产品成本构成_奶粉成本
     */
    @ApiModelProperty("产品成本构成_奶粉成本")
    private String pccMilkPowderCost;

    /**
     * 产品成本构成_油脂成本
     */
    @ApiModelProperty("产品成本构成_油脂成本")
    private String pccOilCost;

    /**
     * 产品成本构成_果粒成本
     */
    @ApiModelProperty("产品成本构成_果粒成本")
    private String pccFruitCost;

    /**
     * 产品成本构成_菌种成本
     */
    @ApiModelProperty("产品成本构成_菌种成本")
    private String pccStrainCost;

    /**
     * 产品成本构成_其他原料成本
     */
    @ApiModelProperty("产品成本构成_其他原料成本")
    private String pccOtherRawMaterialCost;

    /**
     * 产品成本构成_其他辅料成本
     */
    @ApiModelProperty("产品成本构成_其他辅料成本")
    private String pccOtherAuxiliaryMaterialsCost;

    /**
     * 产品成本构成_利乐包材成本
     */
    @ApiModelProperty("产品成本构成_利乐包材成本")
    private String pccLileMaterialCost;

    /**
     * 产品成本构成_康美包材成本
     */
    @ApiModelProperty("产品成本构成_康美包材成本")
    private String pccKangmeiMaterialCost;

    /**
     * 产品成本构成_其他包材成本
     */
    @ApiModelProperty("产品成本构成_其他包材成本")
    private String pccOtherMaterialCost;

    /**
     * 产品成本构成_包装箱成本
     */
    @ApiModelProperty("产品成本构成_包装箱成本")
    private String pccPackingBoxCost;

    /**
     * 产品成本构成_人工成本
     */
    @ApiModelProperty("产品成本构成_人工成本")
    private String pccLaborCost;

    /**
     * 产品成本构成_机器成本
     */
    @ApiModelProperty("产品成本构成_机器成本")
    private String pccMachineCost;

    /**
     * 产品成本构成_间接固定费用成本
     */
    @ApiModelProperty("产品成本构成_间接固定费用成本")
    private String pccIndirectFixedCost;

    /**
     * 产品成本构成_间接变动费用成本
     */
    @ApiModelProperty("产品成本构成_间接变动费用成本")
    private String pccIndirectVariableCost;

    /**
     * 产品成本构成_能源费用成本
     */
    @ApiModelProperty("产品成本构成_能源费用成本")
    private String pccEnergyCost;

    /**
     * 产品成本构成_生产劳务费成本
     */
    @ApiModelProperty("产品成本构成_生产劳务费成本")
    private String pccProductionLaborCost;

    /**
     * 产品成本构成_其他费用消耗成本
     */
    @ApiModelProperty("产品成本构成_其他费用消耗成本")
    private String pccOtherExpensesCost;

    /**
     * 产品成本构成_半成品成本
     */
    @ApiModelProperty("产品成本构成_半成品成本")
    private String pccSemiFinishedProductsCost;

    /**
     * 产品成本构成_产成品成本
     */
    @ApiModelProperty("产品成本构成_产成品成本")
    private String pccFinishedProductsCost;

    /**
     * 产品成本构成_备用01
     */
    @ApiModelProperty("产品成本构成_备用01")
    private String pccStandby01;

    /**
     * 产品成本构成_备用02
     */
    @ApiModelProperty("产品成本构成_备用02")
    private String pccStandby02;

    /**
     * 产品成本构成_备用03
     */
    @ApiModelProperty("产品成本构成_备用03")
    private String pccStandby03;

    /**
     * 产品成本构成_备用04
     */
    @ApiModelProperty("产品成本构成_备用04")
    private String pccStandby04;

    /**
     * 产品成本构成_备用05
     */
    @ApiModelProperty("产品成本构成_备用05")
    private String pccStandby05;

    /**
     * 产品成本构成_备用06
     */
    @ApiModelProperty("产品成本构成_备用06")
    private String pccStandby06;

    /**
     * 实际销售成本
     */
    @ApiModelProperty("实际销售成本")
    private String actualSalesCost;

    /**
     * 委外运费
     */
    @ApiModelProperty("委外运费")
    private String subcontractingFreight;

    /**
     * 库存单位销售数量
     */
    @ApiModelProperty("库存单位销售数量")
    private BigDecimal inventoryUnitSalesNum;

    /**
     * 促销折扣(买赠)
     */
    @ApiModelProperty("促销折扣(买赠)")
    private String promotionDiscountFreePurchase;

    /**
     * 促销折扣(整单）
     */
    @ApiModelProperty("促销折扣(整单）")
    private String promotionDiscountWholeOrder;

    /**
     * 促销折扣(单品)
     */
    @ApiModelProperty("促销折扣(单品)")
    private String promotionDiscountSku;

    /**
     * 发票折扣(整单)
     */
    @ApiModelProperty("发票折扣(整单)")
    private String invoiceDiscountWholeOrder;

    /**
     * 发票折扣(单品)
     */
    @ApiModelProperty("发票折扣(单品)")
    private String invoiceDiscountSku;

    /**
     * 票面折扣(整单)
     */
    @ApiModelProperty("票面折扣(整单)")
    private String faceDiscountWholeOrder;

    /**
     * ds
     */
    @ApiModelProperty("ds")
    private String ds;

    private String tpmCe1MnjtId;

    private String crmCustomerCode;

    @JsonIgnore
    public String getMonthSalesVerifyCode(){

        return this.saleOrgCode +
                this.distributionChannelCode +
                this.productTeamCode +
                this.customerCode +
                this.productCode +
                this.fiscalYear +
                this.period;
    }
}
