package com.biz.crm.tpm.business.third.system.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @className: Ce1MnjtFullVoExportsVo
 * @description: 电商日销售报表导出参数
 * @author: hb
 * @create: 2023-03-24 17:09
 */
@Data
@CrmExcelExport
public class Ce1MnjtFullVoExportsVo extends CrmExcelVo {


    @ApiModelProperty("公司代码")
    @CrmExcelColumn("公司代码")
    private String companyCode;

    @ApiModelProperty("经营范围的货币类型")
    @CrmExcelColumn("货币类型")
    private String businessScopeCurrencyType;

    @ApiModelProperty("记录类型")
    @CrmExcelColumn("记录类型")
    private String recordType;

    @ApiModelProperty("获利分段行项目的凭证号")
    @CrmExcelColumn("凭证编号")
    private String profitSegmentLineItemVoucherNum;

    @ApiModelProperty("记录的创建日期")
    @CrmExcelColumn("创建日期")
    private String documentCreatDate;

    @ApiModelProperty("创建人")
    @CrmExcelColumn("创建者")
    private String creator;

    @ApiModelProperty("财年")
    @CrmExcelColumn("财年")
    private String fiscalYear;

    @ApiModelProperty("期间")
    @CrmExcelColumn("期间")
    private String period;

    @ApiModelProperty("过帐日期")
    private String postDate;

    @ApiModelProperty("客户代码")
    @CrmExcelColumn("客户编码")
    private String customerCode;

    @ApiModelProperty("产品编码")
    @CrmExcelColumn("产品编码")
    private String productCode;

    @ApiModelProperty("开票类型代码")
    private String invoicingTypeCode;

    @ApiModelProperty("开票类型描述")
    @CrmExcelColumn("开票类型")
    private String invoicingTypeName;

    @ApiModelProperty("控制范围")
    @CrmExcelColumn("控制范围")
    private String controlScope;

    @ApiModelProperty("工厂代码")
    @CrmExcelColumn("工厂代码")
    private String factoryCode;

    @ApiModelProperty("销售组织代码")
    @CrmExcelColumn("销售组织代码")
    private String saleOrgCode;

    @ApiModelProperty("分销渠道代码")
    @CrmExcelColumn("分销渠道代码")
    private String distributionChannelCode;

    @ApiModelProperty("产品组代码")
    @CrmExcelColumn("业态")
    private String productTeamCode;

    @ApiModelProperty("成本中心")
    @CrmExcelColumn("成本中心")
    private String costCenter;

    @ApiModelProperty("利润中心代码")
    @CrmExcelColumn("利润中心")
    private String profitCenterCode;

    @ApiModelProperty("物料组代码")
    @CrmExcelColumn("物料组代码")
    private String materialGroupCode;

    @ApiModelProperty("产品层次代码")
    @CrmExcelColumn("产品层次代码")
    private String productLevelCode;

    @ApiModelProperty("品牌代码")
    @CrmExcelColumn("品牌代码")
    private String brand;

    @ApiModelProperty("送达方代码")
    @CrmExcelColumn("送达方代码")
    private String senderCode;

    @ApiModelProperty("销售数量")
    @CrmExcelColumn("销售数量")
    private BigDecimal salesVolumes;

    @ApiModelProperty("含税销售额(净额)")
    @CrmExcelColumn("含税销售额(净额)")
    private String salesIncludingTaxNet;

    @ApiModelProperty("销售含税金额")
    @CrmExcelColumn("销售含税金额")
    private String salesTaxAmount;

    @ApiModelProperty("标准数量(吨)")
    @CrmExcelColumn("标准数量(吨)")
    private BigDecimal standardNumTon;

    @ApiModelProperty("净重量")
    @CrmExcelColumn("净重量(KG)")
    private BigDecimal netWeight;

    @ApiModelProperty("毛重")
    @CrmExcelColumn("毛重(KG)")
    private BigDecimal grossWeight;

}
