package com.biz.crm.tpm.business.third.system.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author: yaoyongming
 * @date: 2023/9/9 14:46
 */
@Data
@ApiModel("平台价格对比表导出")
@CrmExcelExport
public class PlatformPriceExportVo extends CrmExcelVo {
    /**
     * 产品编码
     */
    @CrmExcelColumn("产品编码")
    private String productCode;
    /**
     * 产品名称
     */
    @CrmExcelColumn("产品名称")
    private String productName;
    /**
     * 年月
     */
    @CrmExcelColumn("年月")
    private String yearMonth;
    /**
     * 标准零售价
     */
    @CrmExcelColumn("标准零售价")
    private BigDecimal standardRetailPrice;
    /**
     * 天猫超市（均价）
     */
    @CrmExcelColumn("天猫超市（均价）")
    private BigDecimal tmallChaoshi;
    /**
     * 京东特仑苏（均价）
     */
    @CrmExcelColumn("京东特仑苏（均价）")
    private BigDecimal jdDeluxu;
    /**
     * 线上分销（均价）
     */
    @CrmExcelColumn("线上分销（均价）")
    private BigDecimal distribution;
    /**
     * 京东pop店（均价）
     */
    @CrmExcelColumn("京东pop店（均价）")
    private BigDecimal jdPop;
    /**
     * 京东商城（均价）
     */
    @CrmExcelColumn("京东商城（均价）")
    private BigDecimal jdMarket;
    /**
     * 拓展业务部（均价）
     */
    @CrmExcelColumn("拓展业务部（均价）")
    private BigDecimal expandBusinessDepartment;
    /**
     * 天猫旗舰店（均价）
     */
    @CrmExcelColumn("天猫旗舰店（均价）")
    private BigDecimal tmall;
    /**
     * 拼多多（均价）
     */
    @CrmExcelColumn("拼多多（均价）")
    private BigDecimal pdd;
    /**
     * 内容营销（均价）
     */
    @CrmExcelColumn("内容营销（均价）")
    private BigDecimal contentMarketing;
    /**
     * 社区团购（均价）
     */
    @CrmExcelColumn("社区团购（均价）")
    private BigDecimal community;
    /**
     * 工厂直营（均价）
     */
    @CrmExcelColumn("工厂直营（均价）")
    private BigDecimal factory;
}
