package com.biz.crm.tpm.business.third.system.sdk.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author: yaoyongming
 * @date: 2023/8/22 15:54
 */
@Data
public class PlatformPriceVo {

    /**
     * 销售组织代码
     */
    @ApiModelProperty("销售组织代码")
    private String saleOrgCode;
    /**
     * 业态
     */
    @ApiModelProperty("业态")
    private String productTeamCode;
    /**
     * 分销渠道代码
     */
    @ApiModelProperty("分销渠道代码")
    private String distributionChannelCode;
    /**
     * 客户代码
     */
    @ApiModelProperty("客户代码")
    private String customerCode;
    /**
     * CRM客户代码
     */
    @ApiModelProperty("CRM客户代码")
    private String crmCustomerCode;
    /**
     * 销售数量
     */
    @ApiModelProperty("销售数量")
    private BigDecimal salesVolumes;
    /**
     * 销售含税金额
     */
    @ApiModelProperty("销售含税金额")
    private BigDecimal salesTaxAmount;
    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    private String productCode;
    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    private String productName;
    /**
     * 年月
     */
    @ApiModelProperty("年月")
    private String yearMonth;
    /**
     * 平台
     */
    @ApiModelProperty("平台")
    private String platform;
    /**
     * 标准零售价
     */
    @ApiModelProperty("标准零售价")
    private BigDecimal standardRetailPrice;
    /**
     * 红线价
     */
    @ApiModelProperty("红线价")
    private BigDecimal redLinePrice;
    /**
     * 促销选品价
     */
    @ApiModelProperty("促销选品价")
    private BigDecimal promotionPrice;
    /**
     * 天猫超市（均价）
     */
    @ApiModelProperty("天猫超市（均价）")
    private BigDecimal tmallChaoshi;
    /**
     * 京东特仑苏（均价）
     */
    @ApiModelProperty("京东特仑苏（均价）")
    private BigDecimal jdDeluxu;
    /**
     * 线上分销（均价）
     */
    @ApiModelProperty("线上分销（均价）")
    private BigDecimal distribution;
    /**
     * 京东pop店（均价）
     */
    @ApiModelProperty("京东pop店（均价）")
    private BigDecimal jdPop;
    /**
     * 京东商城
     */
    @ApiModelProperty("京东商城")
    private BigDecimal jdMarket;
    /**
     * 拓展业务部（均价）
     */
    @ApiModelProperty("拓展业务部（均价）")
    private BigDecimal expandBusinessDepartment;
    /**
     * 天猫旗舰店（均价）
     */
    @ApiModelProperty("天猫旗舰店（均价）")
    private BigDecimal tmall;
    /**
     * 拼多多（均价）
     */
    @ApiModelProperty("拼多多（均价）")
    private BigDecimal pdd;
    /**
     * 内容营销（均价）
     */
    @ApiModelProperty("内容营销（均价）")
    private BigDecimal contentMarketing;
    /**
     * 社区团购（均价）
     */
    @ApiModelProperty("社区团购（均价）")
    private BigDecimal community;
    /**
     * 工厂直营（均价）
     */
    @ApiModelProperty("工厂直营（均价）")
    private BigDecimal factory;
}
