package com.biz.crm.tpm.business.third.system.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @ClassName TpmZmsd187Vo
 * @Description
 * @Author: jiangyin
 * @Date 2023/2/13
 */
@Data
@ApiModel("TPM-187数据视图类")
public class TpmZmsd187Vo {

    @ApiModelProperty("客户端")
    private String client;
    @ApiModelProperty("公司代码")
    private String companyCode;
    @ApiModelProperty("销售组织代码")
    private String saleOrgCode;
    @ApiModelProperty("分销渠道")
    private String distributionChannelCode;
    @ApiModelProperty("产品组代码")
    private String productTeamCode;
    @ApiModelProperty("客户编号")
    private String customerCode;
    @ApiModelProperty("销售组")
    private String saleGroupCode;
    @ApiModelProperty("销售部门")
    private String saleDepartmentCode;
    @ApiModelProperty("客户名称")
    private String customerName;
    @ApiModelProperty("财年")
    private String fiscalYear;
    @ApiModelProperty("会计期间")
    private String accountingPeriod;
    @ApiModelProperty("期初余额")
    private BigDecimal openingBalance;
    @ApiModelProperty("TPM转入")
    private BigDecimal tpmShift;
    @ApiModelProperty("开票金额")
    private BigDecimal makeAmount;
    @ApiModelProperty("转入金额")
    private BigDecimal transferInAmount;
    @ApiModelProperty("转出金额")
    private BigDecimal transferOutAmount;
    @ApiModelProperty("扣款金额")
    private BigDecimal deductionAmount;
    @ApiModelProperty("期末余额")
    private BigDecimal endingBalance;
    @ApiModelProperty("未扣款金额")
    private BigDecimal notDeductedAmount;
    @ApiModelProperty("实际费用余额")
    private BigDecimal actualExpenseBalance;
    @ApiModelProperty("记录日期")
    private String recordDate;
    @ApiModelProperty("简短格式的 UTC 时戳 (YYYYMMDDhhmmss)")
    private String timestampOdps;
    @ApiModelProperty("时间分区")
    private String ds;

}
