package com.biz.crm.tpm.business.account.reconciliation.factor.sdk.constant;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

public enum ModalTypeEnum {

    HEAD("head", "头部信息"),
    SUMMARY("summary","汇总信息"),
    SIGN("sign","签署栏"),
    DETAIL("detail","明细信息"),
    TAIL("tail","尾部信息");

    @EnumValue
    @JsonValue
    private String code;
    private String des;

    private ModalTypeEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return this.code;
    }

    public String getDes() {
        return this.des;
    }

    public static ModalTypeEnum codeToEnum(String code) {
        ModalTypeEnum modalType = null;
        ModalTypeEnum[] modalTypeList = values();
        int var3 = modalTypeList.length;

        for (ModalTypeEnum modalTypeEnum : modalTypeList) {
            if (modalTypeEnum.code.equals(code)) {
                modalType = modalTypeEnum;
            }
        }

        return modalType;
    }

}
