package com.biz.crm.tpm.business.account.reconciliation.factor.sdk.constant;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

public enum OptionTypeEnum {

    CREATE("1", "创建"),
    EDIT("2","编辑"),
    ENABLE("3","启用"),
    DISABLE("4","禁用"),
    DELETE("5","删除");

    @EnumValue
    @JsonValue
    private String code;
    private String des;

    private OptionTypeEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return this.code;
    }

    public String getDes() {
        return this.des;
    }

    public static OptionTypeEnum codeToEnum(String code) {
        OptionTypeEnum optionType = null;
        OptionTypeEnum[] optionTypeList = values();
        int var3 = optionTypeList.length;

        for (OptionTypeEnum optionTypeEnum : optionTypeList) {
            if (optionTypeEnum.code.equals(code)) {
                optionType = optionTypeEnum;
            }
        }

        return optionType;
    }
}
