package com.biz.crm.tpm.business.account.reconciliation.factor.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

/**
 * @ClassName TpmAccountReconciliationFactorDto
 * @Description
 * @Author: jiangyin
 * @Date 2022/11/5
 */
@Data
@ApiModel("对账要素数据传输类")
public class TpmAccountReconciliationFactorDto extends TenantFlagOpDto {

    /**
     * 对账要素编码
     */
    @ApiModelProperty(value = "对账要素编码", notes = "")
    private String accountReconciliationFactorCode;

    /**
     * 对账要素名称
     */
    @ApiModelProperty(value = "对账要素名称", notes = "")
    private String accountReconciliationFactorName;

    /**
     * 模块字段名
     */
    @ApiModelProperty(value = "模块字段名", notes = "")
    private String moduleFieldName;

    /**
     * 逻辑名称
     */
    @ApiModelProperty(value = "逻辑名称", notes = "")
    private String logicName;

    /**
     *页面编码
     */
    @ApiModelProperty(value = "页面编码", notes = "")
    private String pageCode;

    /**
     *功能编码
     */
    @ApiModelProperty(value = "功能编码", notes = "")
    private String functionCode;

    /**
     *组件名称
     */
    @ApiModelProperty(value = "组件名称", notes = "")
    private String componentName;

    /**
     *固定参数
     */
    @ApiModelProperty(value = "固定参数", notes = "")
    private String staticParam;

    /**
     *对账类型
     */
    @ApiModelProperty(value = "对账类型", notes = "")
    private String accountReconciliationType;

    /**
     *对账要素配置
     */
    @ApiModelProperty(value = "对账要素配置", notes = "")
    private String factorConfig;

    public boolean validate(){
        return StringUtils.isNotEmpty(this.accountReconciliationFactorName) && StringUtils.isNotEmpty(this.moduleFieldName)
                && StringUtils.isNotEmpty(this.logicName) && StringUtils.isNotEmpty(this.pageCode)
                && StringUtils.isNotEmpty(this.staticParam) && StringUtils.isNotEmpty(this.functionCode)
                && StringUtils.isNotEmpty(this.componentName) && StringUtils.isNotEmpty(this.accountReconciliationType);
    }
}
