package com.biz.crm.tpm.business.account.reconciliation.factor.sdk.event;

import com.biz.crm.tpm.business.account.reconciliation.factor.sdk.dto.TpmAccountReconciliationFactorLogDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * @ClassName TpmAccountReconciliationFactorLogEventListener
 * @Description
 * @Author: jiangyin
 * @Date 2022/11/12
 */
public interface TpmAccountReconciliationFactorLogEventListener extends NebulaEvent {

    /**
     * 当业务单元创建时触发
     *
     * @param dto
     */
    default void onCreate(TpmAccountReconciliationFactorLogDto dto) {
    }

    /**
     * 当业务单元修改时触发
     *
     * @param dto
     */
    default void onUpdate(TpmAccountReconciliationFactorLogDto dto) {
    }

    /**
     * 当业务单元禁用时触发
     *
     * @param dto
     */
    default void onDisable(TpmAccountReconciliationFactorLogDto dto) {
    }

    /**
     * 当业务单元启用时触发
     *
     * @param dto
     */
    default void onEnable(TpmAccountReconciliationFactorLogDto dto) {
    }

    /**
     * 当业务单元删除时触发
     *
     * @param dto
     */
    default void onDelete(TpmAccountReconciliationFactorLogDto dto) {
    }
}
