package com.biz.crm.tpm.business.account.reconciliation.factor.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.account.reconciliation.factor.sdk.dto.TpmAccountReconciliationFactorDto;
import com.biz.crm.tpm.business.account.reconciliation.factor.sdk.vo.TpmAccountReconciliationFactorRespVo;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Set;

/**
 * @author jiangyin
 * @date 2022/11/5 17:50
 */
public interface TpmAccountReconciliationFactorService {

    /**
     * 获取对账要素分页列表
     * @param reqVo 查询参数
     * @param pageable 分页参数
     * @author jiangyin
     * @date 2022/11/7 16:44
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.account.reconciliation.factor.sdk.vo.TpmAccountReconciliationFactorRespVo>
     */
    Page<TpmAccountReconciliationFactorRespVo> findByConditions(TpmAccountReconciliationFactorDto reqVo, Pageable pageable);

    /**
     * 获取对账要素详情
     * @param id 唯一键
     * @author jiangyin
     * @date 2022/11/7 16:45
     * @return com.biz.crm.tpm.business.account.reconciliation.factor.sdk.vo.TpmAccountReconciliationFactorRespVo
     */
    TpmAccountReconciliationFactorRespVo findById(String id);

    /**
     * 根据编码获取对账要素列表
     * @param codes 对账要素编码
     * @return 对账要素列表
     */
    List<TpmAccountReconciliationFactorRespVo> findByCodes(Set<String> codes);

    /**
     * 创建对账要素
     * @param reqVo 保存参数
     * @author jiangyin
     * @date 2022/11/7 16:46
     * @return com.biz.crm.tpm.business.account.reconciliation.factor.sdk.vo.TpmAccountReconciliationFactorRespVo
     */
    TpmAccountReconciliationFactorRespVo create(TpmAccountReconciliationFactorDto reqVo);

    /**
     * 更新对账要素
     * @param reqVo 更新参数
     * @author jiangyin
     * @date 2022/11/7 16:46
     * @return com.biz.crm.tpm.business.account.reconciliation.factor.sdk.vo.TpmAccountReconciliationFactorRespVo
     */
    TpmAccountReconciliationFactorRespVo edit(TpmAccountReconciliationFactorDto reqVo);

    /**
     * 根据唯一键列表逻辑删除对账要素
     * @param ids 唯一键列表
     * @author jiangyin
     * @date 2022/11/7 16:46
     * @return void
     */
    void delete(List<String> ids);

    /**
     * 根据唯一键列表启用对账要素
     * @param ids 唯一键列表
     * @author jiangyin
     * @date 2022/11/7 16:46
     * @return void
     */
    void enable(List<String> ids);

    /**
     * 根据唯一键列表禁用对账要素
     * @param ids 唯一键列表
     * @author jiangyin
     * @date 2022/11/7 16:46
     * @return void
     */
    void disable(List<String> ids);

    boolean checkFactorCodeList(List<String> factorCodeList);

    List<TpmAccountReconciliationFactorRespVo> findByFactorCodeList(List<String> factorCodeList);
}
