package com.biz.crm.tpm.business.account.reconciliation.rule.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.account.reconciliation.rule.feign.feign.internal.AccountReconciliationRuleFeignImpl;
import com.biz.crm.tpm.business.account.reconciliation.rule.sdk.dto.TpmAccountReconciliationRuleDto;
import com.biz.crm.tpm.business.account.reconciliation.rule.sdk.vo.TpmAccountReconciliationRuleRespVo;
import io.swagger.annotations.ApiParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @ClassName AccountReconciliationRuleFeign
 * @Description
 * @Author: jiangyin
 * @Date 2023/5/17
 */
@FeignClient(
        name = "${tpm.feign-client.name:crm-tpm}",
        path = "crm-tpm",
        fallbackFactory = AccountReconciliationRuleFeignImpl.class)
public interface AccountReconciliationRuleFeign {

    @GetMapping("/v1/account/reconciliation/rule/findById")
    Result<TpmAccountReconciliationRuleRespVo> findById(@RequestParam("id") String id);

    @PostMapping("/v1/account/reconciliation/rule/create")
    Result<TpmAccountReconciliationRuleDto> create(@RequestBody TpmAccountReconciliationRuleDto dto);

    @PostMapping(value = "/v1/account/reconciliation/rule/editForPost")
    Result<TpmAccountReconciliationRuleDto> update(@RequestBody TpmAccountReconciliationRuleDto dto);

    @PostMapping(value = "/v1/account/reconciliation/rule/deleteForPost")
    Result<?> delete(@RequestBody List<String> ids);
}
