package com.biz.crm.tpm.business.account.reconciliation.rule.feign.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.account.reconciliation.rule.feign.feign.AccountReconciliationRuleFeign;
import com.biz.crm.tpm.business.account.reconciliation.rule.sdk.dto.TpmAccountReconciliationRuleDto;
import com.biz.crm.tpm.business.account.reconciliation.rule.sdk.vo.TpmAccountReconciliationRuleRespVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @ClassName AccountReconciliationRuleFeignImpl
 * @Description
 * @Author: jiangyin
 * @Date 2023/5/17
 */
@Component
@Slf4j
public class AccountReconciliationRuleFeignImpl implements FallbackFactory<AccountReconciliationRuleFeign> {
    @Override
    public AccountReconciliationRuleFeign create(Throwable cause) {
        log.error("对账规则配置进入熔断");
        return new AccountReconciliationRuleFeign(){

            @Override
            public Result<TpmAccountReconciliationRuleRespVo> findById(String id) {
                throw new UnsupportedOperationException("查询对账规则详情熔断");
            }

            @Override
            public Result<TpmAccountReconciliationRuleDto> create(TpmAccountReconciliationRuleDto dto) {
                throw new UnsupportedOperationException("创建对账规则熔断");
            }

            @Override
            public Result<TpmAccountReconciliationRuleDto> update(TpmAccountReconciliationRuleDto dto) {
                throw new UnsupportedOperationException("更改对账规则熔断");
            }

            @Override
            public Result<?> delete(List<String> ids) {
                throw new UnsupportedOperationException("删除对账规则熔断");
            }
        };
    }
}
