package com.biz.crm.tpm.business.account.reconciliation.rule.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.base.util.DataTooLongGenerateRespUtil;
import com.biz.crm.tpm.business.account.reconciliation.rule.local.entity.TpmAccountReconciliationRuleEntity;
import com.biz.crm.tpm.business.account.reconciliation.rule.sdk.dto.TpmAccountReconciliationRuleDto;
import com.biz.crm.tpm.business.account.reconciliation.rule.sdk.service.TpmAccountReconciliationRuleService;
import com.biz.crm.tpm.business.account.reconciliation.rule.sdk.vo.TpmAccountReconciliationRuleRespVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * (TpmAccountReconciliationRule)表控制层
 *
 * @author jiangyin
 * @since 2022-11-07 17:34:16
 */
@RestController
@RequestMapping("/v1/account/reconciliation/rule")
@Slf4j
@Api(tags = "TPM-对账规则")
public class TpmAccountReconciliationRuleController {
    /**
     * 服务对象
     */
    @Resource
    private TpmAccountReconciliationRuleService tpmAccountReconciliationRuleService;

    /**
     * 分页查询
     *
     * @param reqVo 筛选条件
     * @param pageable 分页对象
     * @return 查询结果
     */
    @PostMapping("findByConditions")
    @ApiOperation(value = "分页查询", notes = "")
    public Result<Page<TpmAccountReconciliationRuleRespVo>> queryByPage(@RequestBody TpmAccountReconciliationRuleDto reqVo, Pageable pageable) {
        try{
            //默认查询未删除数据
            if(StringUtils.isEmpty(reqVo.getDelFlag())){
                reqVo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            }
            return Result.ok(this.tpmAccountReconciliationRuleService.queryByPage(reqVo, pageable));
        } catch (Exception e){
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @GetMapping("findById")
    @ApiOperation(value = "通过主键查询单条数据", notes = "")
    public Result<TpmAccountReconciliationRuleRespVo> queryById(@RequestParam("id") String id) {
        try{
            return Result.ok(this.tpmAccountReconciliationRuleService.queryById(id));
        } catch (Exception e){
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 通过主键查询单条数据
     *
     * @param code 编码
     * @return 单条数据
     */
    @GetMapping("findByCode")
    @ApiOperation(value = "通过主键查询单条数据", notes = "")
    public Result<TpmAccountReconciliationRuleRespVo> findByCode(@RequestParam("code") String code) {
        try{
            return Result.ok(this.tpmAccountReconciliationRuleService.findByCode(code));
        } catch (Exception e){
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 新增数据
     *
     * @param reqVo 实体
     * @return 新增结果
     */
    @PostMapping("create")
    @ApiOperation(value = "新增数据", notes = "")
    public Result<TpmAccountReconciliationRuleDto> create(@RequestBody TpmAccountReconciliationRuleDto reqVo) {
        try{
            return Result.ok(this.tpmAccountReconciliationRuleService.create(reqVo));
        } catch (Exception e){
            log.error(e.getMessage(), e);
            return Result.error(DataTooLongGenerateRespUtil.generateRespStr(e, TpmAccountReconciliationRuleEntity.class));
        }
    }

    /**
     * 编辑数据
     *
     * @param reqVo 实体
     * @return 编辑结果
     */
    @PatchMapping("edit")
    @ApiOperation(value = "编辑数据", notes = "")
    public Result<TpmAccountReconciliationRuleDto> edit(@RequestBody TpmAccountReconciliationRuleDto reqVo) {
        try{
            return Result.ok(this.tpmAccountReconciliationRuleService.edit(reqVo));
        } catch (Exception e){
            log.error(e.getMessage(), e);
            return Result.error(DataTooLongGenerateRespUtil.generateRespStr(e, TpmAccountReconciliationRuleEntity.class));
        }
    }

    /**
     * 编辑数据
     *
     * @param reqVo 实体
     * @return 编辑结果
     */
    @PostMapping("editForPost")
    @ApiOperation(value = "编辑数据-能力中心", notes = "")
    public Result<TpmAccountReconciliationRuleDto> editForPost(@RequestBody TpmAccountReconciliationRuleDto reqVo) {
        try{
            return Result.ok(this.tpmAccountReconciliationRuleService.edit(reqVo));
        } catch (Exception e){
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 删除数据
     *
     * @param ids 主键
     * @return 删除是否成功
     */
    @DeleteMapping("delete")
    @ApiOperation(value = "删除数据", notes = "")
    public Result<?> deleteById(@RequestParam("ids") List<String> ids) {
        try{
            this.tpmAccountReconciliationRuleService.deleteByIdList(ids);
            return Result.ok();
        } catch (Exception e){
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 删除数据
     *
     * @param ids 主键
     * @return 删除是否成功
     */
    @PostMapping("deleteForPost")
    @ApiOperation(value = "删除数据", notes = "")
    public Result<?> deleteForPost(@RequestBody List<String> ids) {
        try{
            this.tpmAccountReconciliationRuleService.deleteByIdList(ids);
            return Result.ok();
        } catch (Exception e){
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 启用数据
     *
     * @param ids 主键
     * @return 删除是否成功
     */
    @PatchMapping("enable")
    @ApiOperation(value = "", notes = "")
    public Result<?> enable(@RequestBody List<String> ids) {
        try{
            this.tpmAccountReconciliationRuleService.enable(ids);
            return Result.ok();
        } catch (Exception e){
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 禁用数据
     *
     * @param ids 主键
     * @return 删除是否成功
     */
    @PatchMapping("disable")
    @ApiOperation(value = "", notes = "")
    public Result<?> disable(@RequestBody List<String> ids) {
        try{
            this.tpmAccountReconciliationRuleService.disable(ids);
            return Result.ok();
        } catch (Exception e){
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}

