package com.biz.crm.tpm.business.account.reconciliation.rule.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.account.reconciliation.rule.sdk.dto.TpmAccountReconciliationRuleDateConfigDto;
import com.biz.crm.tpm.business.account.reconciliation.rule.sdk.service.TpmAccountReconciliationRuleDateConfigService;
import com.biz.crm.tpm.business.account.reconciliation.rule.sdk.vo.TpmAccountReconciliationRuleDateConfigRespVo;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * (TpmAccountReconciliationRuleDateConfig)表控制层
 *
 * @author jiangyin
 * @since 2022-11-07 17:40:31
 */
@RestController
@RequestMapping("tpmAccountReconciliationRuleDateConfig")
public class TpmAccountReconciliationRuleDateConfigController {
    /**
     * 服务对象
     */
    @Resource
    private TpmAccountReconciliationRuleDateConfigService tpmAccountReconciliationRuleDateConfigService;

    /**
     * 分页查询
     *
     * @param  reqVo 筛选条件
     * @param  pageable 分页对象
     * @return 查询结果
     */
    @PostMapping("findByConditions")
    public Result<Page<TpmAccountReconciliationRuleDateConfigRespVo>> findByConditions(@RequestBody TpmAccountReconciliationRuleDateConfigDto reqVo, Pageable pageable) {
        return Result.ok(this.tpmAccountReconciliationRuleDateConfigService.queryByPage(reqVo, pageable));
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @GetMapping("findById")
    public Result<TpmAccountReconciliationRuleDateConfigRespVo> queryById(@RequestParam("id") String id) {
        return Result.ok(this.tpmAccountReconciliationRuleDateConfigService.queryById(id));
    }

    /**
     * 新增数据
     *
     * @param reqVo 实体
     * @return 新增结果
     */
    @PostMapping
    public Result<TpmAccountReconciliationRuleDateConfigRespVo> create(@RequestBody TpmAccountReconciliationRuleDateConfigDto reqVo) {
        return Result.ok(this.tpmAccountReconciliationRuleDateConfigService.create(reqVo));
    }

    /**
     * 编辑数据
     *
     * @param reqVo 实体
     * @return 编辑结果
     */
    @PatchMapping
    public Result<TpmAccountReconciliationRuleDateConfigRespVo> edit(@RequestBody TpmAccountReconciliationRuleDateConfigDto reqVo) {
        return Result.ok(this.tpmAccountReconciliationRuleDateConfigService.edit(reqVo));
    }

    /**
     * 删除数据
     *
     * @param id 主键
     * @return 删除是否成功
     */
    @DeleteMapping
    public Result<Boolean> deleteById(String id) {
        return Result.ok(this.tpmAccountReconciliationRuleDateConfigService.deleteById(id));
    }

}

