package com.biz.crm.tpm.business.account.reconciliation.rule.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.account.reconciliation.rule.sdk.dto.TpmAccountReconciliationRuleRFactorDto;
import com.biz.crm.tpm.business.account.reconciliation.rule.sdk.service.TpmAccountReconciliationRuleRFactorService;
import com.biz.crm.tpm.business.account.reconciliation.rule.sdk.vo.TpmAccountReconciliationRuleRFactorRespVo;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * (TpmAccountReconciliationRuleRFactory)表控制层
 *
 * @author jiangyin
 * @since 2022-11-07 17:42:55
 */
@RestController
@RequestMapping("tpmAccountReconciliationRuleRFactory")
public class TpmAccountReconciliationRuleRFactorController {
    /**
     * 服务对象
     */
    @Resource
    private TpmAccountReconciliationRuleRFactorService tpmAccountReconciliationRuleRFactorService;

    /**
     * 分页查询
     *
     * @param reqVo 筛选条件
     * @param pageRequest 分页对象
     * @return 查询结果
     */
    @GetMapping
    public Result<Page<TpmAccountReconciliationRuleRFactorRespVo>> queryByPage(TpmAccountReconciliationRuleRFactorDto reqVo, PageRequest pageRequest) {
        return Result.ok(this.tpmAccountReconciliationRuleRFactorService.queryByPage(reqVo, pageRequest));
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @GetMapping("{id}")
    public Result<TpmAccountReconciliationRuleRFactorRespVo> queryById(@PathVariable("id") String id) {
        return Result.ok(this.tpmAccountReconciliationRuleRFactorService.queryById(id));
    }

    /**
     * 新增数据
     *
     * @param reqVo 实体
     * @return 新增结果
     */
    @PostMapping
    public Result<TpmAccountReconciliationRuleRFactorRespVo> create(TpmAccountReconciliationRuleRFactorDto reqVo) {
        return Result.ok(this.tpmAccountReconciliationRuleRFactorService.create(reqVo));
    }

    /**
     * 编辑数据
     *
     * @param reqVo 实体
     * @return 编辑结果
     */
    @PatchMapping
    public Result<TpmAccountReconciliationRuleRFactorRespVo> edit(TpmAccountReconciliationRuleRFactorDto reqVo) {
        return Result.ok(this.tpmAccountReconciliationRuleRFactorService.edit(reqVo));
    }

    /**
     * 删除数据
     *
     * @param id 主键
     * @return 删除是否成功
     */
    @DeleteMapping
    public Result<Boolean> deleteById(String id) {
        return Result.ok(this.tpmAccountReconciliationRuleRFactorService.deleteById(id));
    }

}

