package com.biz.crm.tpm.business.account.reconciliation.rule.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.util.Date;
import java.io.Serializable;

/**
 * (TpmAccountReconciliationRuleDateConfig)实体类
 *
 * @author jiangyin
 * @since 2022-11-07 17:40:36
 */
@ApiModel(value = "TpmAccountReconciliationFactorEntity", description = "TPM-对账规则计算时间配置实体类")
@TableName("tpm_account_reconciliation_rule_date_config")
@Getter
@Setter
@Entity(name = "tpm_account_reconciliation_rule_date_config")
@org.hibernate.annotations.Table(appliesTo = "tpm_account_reconciliation_rule_date_config", comment = "TPM-对账规则计算时间配置实体类")
@Table(name = "tpm_account_reconciliation_rule_date_config", indexes = {
        @Index(name = "tpm_account_r_rule_date_config_idx1", columnList = "account_reconciliation_rule_code", unique = false)
})
public class TpmAccountReconciliationRuleDateConfigEntity extends TenantFlagOpEntity implements Serializable {
    private static final long serialVersionUID = 809475538295692898L;
    /**
     * 对账规则编码
     */
    @ApiModelProperty(value = "对账规则编码", notes = "")
    @Column(name = "account_reconciliation_rule_code", nullable = true, length = 20, columnDefinition = "varchar(20) COMMENT '对账规则编码'")
    private String accountReconciliationRuleCode;
    /**
     * 计算开始时间
     */
    @ApiModelProperty(value = "计算开始时间", notes = "")
    @Column(name = "start_date", nullable = true, length = 20, columnDefinition = "datetime COMMENT '计算开始时间'")
    private Date startDate;
    /**
     * 计算结束时间
     */
    @ApiModelProperty(value = "计算结束时间", notes = "")
    @Column(name = "end_date", nullable = true, length = 20, columnDefinition = "datetime COMMENT '计算结束时间'")
    private Date endDate;
    /**
     * 计算时间
     */
    @ApiModelProperty(value = "计算时间", notes = "")
    @Column(name = "calculate_date", nullable = true, columnDefinition = "datetime COMMENT '计算时间'")
    private Date calculateDate;

}

