package com.biz.crm.tpm.business.account.reconciliation.rule.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.util.Date;
import java.io.Serializable;

/**
 * (TpmAccountReconciliationRule)实体类
 *
 * @author jiangyin
 * @since 2022-11-07 17:33:45
 */
@ApiModel(value = "TpmAccountReconciliationFactorEntity", description = "TPM-对账规则实体类")
@TableName("tpm_account_reconciliation_rule")
@Getter
@Setter
@Entity(name = "tpm_account_reconciliation_rule")
@org.hibernate.annotations.Table(appliesTo = "tpm_account_reconciliation_rule", comment = "TPM-对账规则")
@Table(name = "tpm_account_reconciliation_rule", indexes = {
        @Index(name = "rule_code_index", columnList = "account_reconciliation_rule_code", unique = true),

})
public class TpmAccountReconciliationRuleEntity extends TenantFlagOpEntity implements Serializable {
    private static final long serialVersionUID = 511390331813320180L;
    /**
     * 对账规则编码
     */
    @ApiModelProperty(value = "对账规则编码", notes = "")
    @Column(name = "account_reconciliation_rule_code", nullable = true, length = 20, columnDefinition = "varchar(20) unique COMMENT '对账规则编码'")
    private String accountReconciliationRuleCode;
    /**
     * 对账规则名称
     */
    @ApiModelProperty(value = "对账规则名称", notes = "")
    @Column(name = "account_reconciliation_rule_name", nullable = true, length = 200, columnDefinition = "varchar(200) COMMENT '对账规则名称'")
    private String accountReconciliationRuleName;

    /**
     * 对账类型
     */
    @ApiModelProperty(value = "对账类型", notes = "")
    @Column(name = "account_reconciliation_type", nullable = true, length = 20, columnDefinition = "varchar(20) COMMENT '对账类型'")
    private String accountReconciliationType;
    /**
     * 有效开始时间
     */
    @ApiModelProperty(value = "有效开始时间", notes = "")
    @Column(name = "start_date", nullable = true, columnDefinition = "datetime COMMENT '有效开始时间'")
    private Date startDate;
    /**
     * 有效结束时间
     */
    @ApiModelProperty(value = "有效结束时间", notes = "")
    @Column(name = "end_date", nullable = true, columnDefinition = "datetime COMMENT '有效结束时间'")
    private Date endDate;
    /**
     * 生成周期
     */
    @ApiModelProperty(value = "生成周期", notes = "")
    @Column(name = "generate_period", nullable = true, length = 20, columnDefinition = "varchar(20) COMMENT '生成周期'")
    private String generatePeriod;
    /**
     * 生成时间
     */
    @ApiModelProperty(value = "生成时间", notes = "")
    @Column(name = "generate_cost_day", nullable = true, columnDefinition = "int COMMENT '生成时间'")
    private Integer generateCostDay;
    /**
     * 业态编码
     */
    @ApiModelProperty(value = "业态编码", notes = "")
    @Column(name = "business_format_code", nullable = true, length = 60, columnDefinition = "varchar(60) COMMENT '业态编码'")
    private String businessFormatCode;
    /**
     * 业务单元编码
     */
    @ApiModelProperty(value = "业务单元编码", notes = "")
    @Column(name = "business_unit_code", nullable = true, length = 60, columnDefinition = "varchar(60) COMMENT '业务单元编码'")
    private String businessUnitCode;

}

