package com.biz.crm.tpm.business.account.reconciliation.rule.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * (TpmAccountReconciliationRuleRFactory)实体类
 *
 * @author jiangyin
 * @since 2022-11-07 17:43:07
 */
@ApiModel(value = "TpmAccountReconciliationRuleRFactor", description = "TPM-对账规则关联对账要素表实体类")
@TableName("tpm_account_reconciliation_rule_r_factor")
@Getter
@Setter
@Entity(name = "tpm_account_reconciliation_rule_r_factor")
@org.hibernate.annotations.Table(appliesTo = "tpm_account_reconciliation_rule_r_factor", comment = "TPM-对账规则关联对账要素表")
@Table(name = "tpm_account_reconciliation_rule_r_factor", indexes = {
        @Index(name = "tpm_account_r_rule_r_factor_idx1", columnList = "account_reconciliation_rule_code", unique = false)
})
public class TpmAccountReconciliationRuleRFactorEntity extends TenantFlagOpEntity implements Serializable {
    private static final long serialVersionUID = 447547994340433642L;
    /**
     * 对账规则编码
     */
    @ApiModelProperty(value = "对账规则编码", notes = "")
    @Column(name = "account_reconciliation_rule_code", nullable = true, length = 20, columnDefinition = "varchar(20) COMMENT '对账规则编码'")
    private String accountReconciliationRuleCode;
    /**
     * 对账要素编码
     */
    @ApiModelProperty(value = "对账要素编码", notes = "")
    @Column(name = "account_reconciliation_factor_code", nullable = true, length = 20, columnDefinition = "varchar(20) COMMENT '对账要素编码'")
    private String accountReconciliationFactorCode;
    /**
     * 排序
     */
    @ApiModelProperty(value = "排序", notes = "")
    @Column(name = "order_num", nullable = true, columnDefinition = "int COMMENT '排序'")
    private Integer orderNum;
}

