package com.biz.crm.tpm.business.account.reconciliation.rule.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.tpm.business.account.reconciliation.rule.local.entity.TpmAccountReconciliationRuleDateConfigEntity;
import com.biz.crm.tpm.business.account.reconciliation.rule.sdk.vo.TpmAccountReconciliationRuleDateConfigRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * (TpmAccountReconciliationRuleDateConfig)表数据库访问层
 *
 * @author jiangyin
 * @since 2022-11-07 17:40:33
 */
public interface TpmAccountReconciliationRuleDateConfigMapper extends BaseMapper<TpmAccountReconciliationRuleDateConfigEntity> {

    /**
     * 根据对账规则主键删除对账规则时间配置
     * @param id 主键
     * @param tenantCode
     * @author jiangyin
     * @date 2022/11/9 16:20
     * @return int
     */
    int deleteByRuleIdAndTenantCode(@Param("id") String id, @Param("tenantCode") String tenantCode);

    /**
     * 根据主键查询对账规则时间配置
     * @param codeList
     * @param tenantCode
     * @author jiangyin
     * @date 2022/11/9 16:20
     * @return java.util.List<com.biz.crm.tpm.business.account.reconciliation.rule.sdk.vo.TpmAccountReconciliationRuleDateConfigRespVo>
     */
    List<TpmAccountReconciliationRuleDateConfigRespVo> findByRuleCodes(@Param("codeList")List<String> codeList,@Param("tenantCode") String tenantCode);
    /**
     * 根据对账规则主键批量删除对账规则时间配置
     * @param idList 主键列表
     * @param tenantCode
     * @author jiangyin
     * @date 2022/11/9 16:39
     * @return int
     */
    int deleteByRuleIdListAndTenantCode(@Param("idList") List<String> idList, String tenantCode);

    /**
     * 根据对账规则主键批量启用
     * @param idList 主键列表
     * @author jiangyin
     * @date 2022/11/9 16:40
     * @return int
     */
    int enableByRuleIdList(@Param("idList") List<String> idList);

    /**
     * 根据对账规则主键批量禁用
     * @param idList 主键列表
     * @author jiangyin
     * @date 2022/11/9 16:40
     * @return int
     */
    int disableByRuleIdList(@Param("idList") List<String> idList);

}

