package com.biz.crm.tpm.business.account.reconciliation.rule.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.account.reconciliation.factor.sdk.vo.TpmAccountReconciliationFactorRespVo;
import com.biz.crm.tpm.business.account.reconciliation.rule.local.entity.TpmAccountReconciliationRuleEntity;
import com.biz.crm.tpm.business.account.reconciliation.rule.sdk.dto.TpmAccountReconciliationRuleDto;
import com.biz.crm.tpm.business.account.reconciliation.rule.sdk.vo.TpmAccountReconciliationRuleRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * (TpmAccountReconciliationRule)表数据库访问层
 *
 * @author jiangyin
 * @since 2022-11-07 17:34:17
 */
public interface TpmAccountReconciliationRuleMapper extends BaseMapper<TpmAccountReconciliationRuleEntity> {

    /**
     * 根据主键查询对账规则主体信息
     * @param id 主键
     * @author jiangyin
     * @date 2022/11/9 16:15
     * @return com.biz.crm.tpm.business.account.reconciliation.rule.sdk.vo.TpmAccountReconciliationRuleRespVo
     */
    TpmAccountReconciliationRuleRespVo findByIdAndTenantCode(@Param("id") String id, @Param("tenantCode") String tenantCode);

    /**
     * 查询对账规则列表
     * @param page 分页参数
	 * @param reqVo 请求参数
     * @author jiangyin
     * @date 2022/11/9 16:15
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.account.reconciliation.rule.sdk.vo.TpmAccountReconciliationRuleRespVo>
     */
    Page<TpmAccountReconciliationRuleRespVo> findByConditions(Page<TpmAccountReconciliationFactorRespVo> page,@Param("vo") TpmAccountReconciliationRuleDto reqVo);

    /**
     * 逻辑删除
     * @param id 主键
     * @author jiangyin
     * @date 2022/11/9 16:15
     * @return int
     */
    int logicDeleteById(@Param("id") String id, @Param("tenantCode") String tenantCode);

    /**
     * 批量删除
     * @param idList 主键列表
     * @param tenantCode
     * @author jiangyin
     * @date 2022/11/9 16:16
     * @return int
     */
    int logicDeleteByIdList(@Param("idList") List<String> idList, @Param("tenantCode") String tenantCode);

    /**
     * 批量启用
     * @param idList 主键列表
     * @author jiangyin
     * @date 2022/11/9 16:18
     * @return int
     */
    int enableByIdList(@Param("idList") List<String> idList);

    /**
     * 批量禁用
     * @param idList 主键列表
     * @author jiangyin
     * @date 2022/11/9 16:18
     * @return int
     */
    int disableByIdList(@Param("idList") List<String> idList);

    Page<TpmAccountReconciliationRuleRespVo> findCurrentEffectiveRule(Page<TpmAccountReconciliationRuleRespVo> page, @Param("tenantCode") String tenantCode);

    List<String> findExist(@Param("vo") TpmAccountReconciliationRuleDto reqVo);

    TpmAccountReconciliationRuleRespVo findByCodeAndTenantCode(@Param("code") String code, @Param("tenantCode") String tenantCode);

    List<TpmAccountReconciliationRuleEntity> findByIdListAndTenantCode(@Param("idList") List<String> ids, @Param("tenantCode") String tenantCode);
}

