package com.biz.crm.tpm.business.account.reconciliation.rule.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.tpm.business.account.reconciliation.rule.local.entity.TpmAccountReconciliationRuleRFactorEntity;
import com.biz.crm.tpm.business.account.reconciliation.rule.sdk.vo.TpmAccountReconciliationRuleRFactorRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * (TpmAccountReconciliationRuleRFactory)表数据库访问层
 *
 * @author jiangyin
 * @since 2022-11-07 17:43:07
 */
public interface TpmAccountReconciliationRuleRFactorMapper extends BaseMapper<TpmAccountReconciliationRuleRFactorEntity> {

    /**
     * 根据对账规则主键删除关联对账要素
     * @param id 对账规则主键
     * @param tenantCode
     * @author jiangyin
     * @date 2022/11/9 16:50
     * @return int
     */
    int deleteByRuleIdAndTenantCode(@Param("id") String id, @Param("tenantCode") String tenantCode);

    /**
     * 根据对账规则主键查询对账要素
     * @param codeList
     * @param tenantCode
     * @author jiangyin
     * @date 2022/11/9 16:50
     * @return java.util.List<com.biz.crm.tpm.business.account.reconciliation.rule.sdk.vo.TpmAccountReconciliationRuleRFactorRespVo>
     */
    List<TpmAccountReconciliationRuleRFactorRespVo> findByRuleCodes(@Param("codeList")List<String> codeList,@Param("tenantCode") String tenantCode);

    /**
     * 根据对账规则主键删除关联对账要素
     * @param idList 对账规则主键列表
     * @param tenantCode
     * @author jiangyin
     * @date 2022/11/9 16:50
     * @return int
     */
    int deleteByRuleIdListAndTenantCode(@Param("idList") List<String> idList, String tenantCode);

    /**
     * 根据对账规则主键启用关联对账要素
     * @param idList 对账规则主键列表
     * @author jiangyin
     * @date 2022/11/9 16:50
     * @return int
     */
    int enableByRuleIdList(@Param("idList") List<String> idList);

    /**
     * 根据对账规则主键禁用关联对账要素
     * @param ids 对账规则主键列表
     * @author jiangyin
     * @date 2022/11/9 16:50
     * @return int
     */
    int disableByRuleIdList(@Param("idList") List<String> ids);
}

