package com.biz.crm.tpm.business.account.reconciliation.rule.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 对账规则表单注册
 * @ClassName TpmAccountReconciliationRuleRegister
 * @Description
 * @Author: jiangyin
 * @Date 2022/11/9
 */
@Component
@Slf4j
public class TpmAccountReconciliationRuleRegister implements DataviewRegister {

    @Override
    public String code() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String desc() {
        return "TPM-对账规则";
    }

    @Override
    public String buildSql() {
        return "select t.* from tpm_account_reconciliation_rule t " +
                "where t.tenant_code = :tenantCode " +
                "and t.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' ";
    }

}
